/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.commands;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.ComponentLibrary;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.core.layout.LayoutDef;
import jp.sf.maskat.ui.editors.layout.tools.ComponentUtils;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class AddComponentCommand
extends Command {
    protected Component parent;
    protected Component component;
    protected Rectangle constraint;
    private boolean addedPrefixMapping;

    public AddComponentCommand(Component parent, Component component) {
        this.parent = parent;
        this.component = component;
        this.addedPrefixMapping = false;
    }

    public void setConstraint(Rectangle rectangle) {
        this.constraint = rectangle;
    }

    public void execute() {
        if (this.constraint.width == -1 && this.constraint.height == -1) {
            if (this.component instanceof DynaComponent) {
                DynaComponent dynaComponent = (DynaComponent)this.component;
                DynaComponentClass dynaClass = (DynaComponentClass)dynaComponent.getDynaClass();
                if (dynaClass.isLeftMovable()) {
                    this.component.setLeft(this.constraint.x);
                }
                if (dynaClass.isTopMovable()) {
                    this.component.setTop(this.constraint.y);
                }
            } else {
                this.component.setLeft(this.constraint.x);
                this.component.setTop(this.constraint.y);
            }
        } else {
            this.component.setConstraint(this.constraint.x, this.constraint.y, this.constraint.width, this.constraint.height);
        }
        if (this.component instanceof DynaComponent) {
            LayoutDef layoutDef = this.parent.getLayout().getLayoutDef();
            DynaComponent dynaComponent = (DynaComponent)this.component;
            DynaComponentClass dynaClass = (DynaComponentClass)dynaComponent.getDynaClass();
            ComponentLibrary library = dynaClass.getLibrary();
            String namespace = library.getNamespaceURI();
            String prefix = library.getPrefix();
            if (namespace == null || "".equals(namespace)) {
                this.addedPrefixMapping = false;
            } else if (!layoutDef.getNamespaces().containsKey(namespace)) {
                layoutDef.getNamespaces().put(namespace, prefix);
                this.addedPrefixMapping = true;
            }
        }
        ComponentUtils.setUniqueName(this.parent.getLayout(), this.component);
        this.parent.addChild((Object)this.component);
    }

    public void undo() {
        this.parent.removeChild((Object)this.component);
        if (this.component instanceof DynaComponent && this.addedPrefixMapping) {
            DynaComponent dynaBean = (DynaComponent)this.component;
            DynaComponentClass dynaClass = (DynaComponentClass)dynaBean.getDynaClass();
            String namespaceURI = dynaClass.getLibrary().getNamespaceURI();
            LayoutDef layoutDef = this.parent.getLayout().getLayoutDef();
            layoutDef.getNamespaces().remove(namespaceURI);
        }
    }

    public boolean canUndo() {
        return true;
    }
}

