/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.layout.Window;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class WindowPropertySource extends AbstractComponentPropertySource {

	public static final String PROP_NAME = "_prop_name_";
	
	public static final String PROP_LEFT = "_prop_left_";
	
	public static final String PROP_TOP = "_prop_top_";
	
	public static final String PROP_TITLE = "_prop_title_";
	
	public static final String PROP_AUTORESIZABLEH = "_prop_autoResizableH_";
	
	public static final String PROP_AUTORESIZABLEW = "_prop_autoResizableW_";
	
	public static final String PROP_BWITHOUTPLACEIN = "_prop_bWithoutPlaceIn_";
	
	public static final String PROP_ICONE = "_prop_icone_";
	
	public static final String PROP_POSITION = "_prop_position_";
	
	public static final String PROP_WITHCLOSEBUTON = "_prop_withCloseButon_";
	
	public static final String PROP_STYLE = "_prop_style_";

	public WindowPropertySource(Window window) {
		super(window);
	}
	
	protected void initialize() {
		descriptor = new PropertyDescriptor[] {
				  new MaskatTextPropertyDescriptor(PROP_NAME, "name"),
				  //new MaskatTextPropertyDescriptor(PROP_LEFT, "left"),
				  //new MaskatTextPropertyDescriptor(PROP_TOP, "top"),
				  new MaskatTextPropertyDescriptor(PROP_TITLE, "title"),
				  new MaskatTextPropertyDescriptor(PROP_STYLE, "style"),
				  //new BooleanComboBoxPropertyDescriptor(PROP_AUTORESIZABLEH, "autoResizableH"),
				  //new BooleanComboBoxPropertyDescriptor(PROP_AUTORESIZABLEW, "autoResizableW"),
				  //new BooleanComboBoxPropertyDescriptor(PROP_BWITHOUTPLACEIN, "bWithoutPlaceIn"),
				  new MaskatTextPropertyDescriptor(PROP_ICONE, "icone")};
				  //new MaskatComboBoxPropertyDescriptor(PROP_POSITION, "position", ComboBoxLabelConstants.POSITION),
				  //new BooleanComboBoxPropertyDescriptor(PROP_WITHCLOSEBUTON, "withCloseButon")};
		
		//make sure the "..." values are the same as bean's properties.
	    propMap.put(PROP_NAME, "name");
	    //propMap.put(PROP_LEFT, "left");
	    //propMap.put(PROP_TOP, "top");
	    propMap.put(PROP_TITLE, "title");
	    propMap.put(PROP_STYLE, "style");
	    //propMap.put(PROP_AUTORESIZABLEH, "autoResizableH");
	    //propMap.put(PROP_AUTORESIZABLEW, "autoResizableW");
	    //propMap.put(PROP_BWITHOUTPLACEIN, "bWithoutPlaceIn");
	    propMap.put(PROP_ICONE, "icone");
	    //propMap.put(PROP_POSITION, "position");
	    //propMap.put(PROP_WITHCLOSEBUTON, "withCloseButon");

	}
}
