/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.layout.TreeNode;
import org.maskat.ui.views.properties.descriptor.BooleanComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class TreeNodePropertySource extends AbstractComponentPropertySource {

	public static final String PROP_NAME = "_prop_name_";
	
	public static final String PROP_STEXT = "_prop_sText_";
	
	public static final String PROP_DRAGGABLE = "_prop_draggable_";
	
	public static final String PROP_OPEN = "_prop_open_";
	
	public static final String PROP_POSITION = "_prop_position_";
	
	public static final String PROP_RELOAD = "_prop_reload_";
	
	public static final String PROP_SICON = "_prop_sIcon_";
	
	public static final String PROP_SICON2 = "_prop_sIcon2_";
	
	public static final String PROP_TYPEINFO = "_prop_typeInfo_";
	
	public static final String PROP_URL = "_prop_url_";
	
	public static final String PROP_ONCLICK = "_prop_onclick_";

	public TreeNodePropertySource(TreeNode treeNode) {
		super(treeNode);
	}
	
	protected void initialize() {
		descriptor = new PropertyDescriptor[] {
				  new MaskatTextPropertyDescriptor(PROP_NAME, "name"),
				  new MaskatTextPropertyDescriptor(PROP_STEXT, "sText"),
//				  new BooleanComboBoxPropertyDescriptor(PROP_DRAGGABLE, "draggable"),
				  new BooleanComboBoxPropertyDescriptor(PROP_OPEN, "open"),
				  new MaskatTextPropertyDescriptor(PROP_ONCLICK, "onclick"),
//				  new MaskatComboBoxPropertyDescriptor(PROP_POSITION, "position", ComboBoxConstant.POSITION),
//				  new MaskatTextPropertyDescriptor(PROP_RELOAD, "reload"),
//				  new MaskatTextPropertyDescriptor(PROP_TYPEINFO, "typeInfo"),
//				  new MaskatTextPropertyDescriptor(PROP_URL, "url"),
				  new MaskatTextPropertyDescriptor(PROP_SICON, "sIcon"),
				  new MaskatTextPropertyDescriptor(PROP_SICON2, "sIcon2")};
		
		//make sure the "..." values are the same as bean's properties.
	    propMap.put(PROP_NAME, "name");
	    propMap.put(PROP_STEXT, "sText");
	    propMap.put(PROP_DRAGGABLE, "draggable");
	    propMap.put(PROP_OPEN, "open");
	    propMap.put(PROP_ONCLICK, "onclick");
	    //	    propMap.put(PROP_POSITION, "position");
//	    propMap.put(PROP_RELOAD, "reload");
	    propMap.put(PROP_SICON, "sIcon");
	    propMap.put(PROP_SICON2, "sIcon2");
//	    propMap.put(PROP_TYPEINFO, "typeInfo");
//	    propMap.put(PROP_URL, "url");

	}
}
