/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.layout.GridHeader;
import org.maskat.ui.views.properties.descriptor.ComboBoxLabelConstants;
import org.maskat.ui.views.properties.descriptor.MaskatComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class GridHeaderPropertySource extends AbstractComponentPropertySource {

	public static final String PROP_WIDTH = "_prop_width_";
	
	public static final String PROP_TITLE = "_prop_title_";
	
	public static final String PROP_TYPE = "_prop_type_";

	public GridHeaderPropertySource(GridHeader gridHeader) {
		super(gridHeader);
	}
	
	protected void initialize() {
		descriptor = new PropertyDescriptor[] {
				  new MaskatTextPropertyDescriptor(PROP_WIDTH, "width"),
				  new MaskatTextPropertyDescriptor(PROP_TITLE, "title"),
				  new MaskatComboBoxPropertyDescriptor(PROP_TYPE, "type", ComboBoxLabelConstants.GRIDHEADER_TYPE)};
		
		//make sure the "..." values are the same as bean's properties.
	    propMap.put(PROP_WIDTH, "width");
	    propMap.put(PROP_TITLE, "title");
	    propMap.put(PROP_TYPE, "type");

	}
}
