/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.layout.DivHtml;
import org.maskat.ui.views.properties.descriptor.ComboBoxLabelConstants;
import org.maskat.ui.views.properties.descriptor.MaskatComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class DivHtmlPropertySource extends AbstractComponentPropertySource {

	public static final String PROP_NAME = "_prop_name_";

	public static final String PROP_LEFT = "_prop_left_";
	
	public static final String PROP_TOP = "_prop_top_";
	
	public static final String PROP_CLASSNAME = "_prop_className_";
	
	public static final String PROP_POSITION = "_prop_position_";
	
	public static final String PROP_HTML = "_prop_html_";

	public DivHtmlPropertySource(DivHtml divHtml) {
		super(divHtml);
	}
	
	protected void initialize() {
		descriptor = new PropertyDescriptor[] {
				  new MaskatTextPropertyDescriptor(PROP_NAME, "name"),
				  new MaskatTextPropertyDescriptor(PROP_LEFT, "left"),
				  new MaskatTextPropertyDescriptor(PROP_TOP, "top"),
				  new MaskatTextPropertyDescriptor(PROP_HTML, "html"),
				  new MaskatComboBoxPropertyDescriptor(PROP_POSITION, "position", ComboBoxLabelConstants.POSITION),
				  new MaskatTextPropertyDescriptor(PROP_CLASSNAME, "className")};
		
		//make sure the "..." values are the same as bean's properties.
	    propMap.put(PROP_NAME, "name");
	    propMap.put(PROP_LEFT, "left");
	    propMap.put(PROP_TOP, "top");
	    propMap.put(PROP_CLASSNAME, "className");
	    propMap.put(PROP_POSITION, "position");
	    propMap.put(PROP_HTML, "html");

	}
}
