/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.layout.Checkbox;
import org.maskat.ui.views.properties.descriptor.BooleanComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class CheckboxPropertySource extends AbstractComponentPropertySource {

	public static final String PROP_NAME = "_prop_name_";
	 
	public static final String PROP_TOP = "_prop_top_";
	 
	public static final String PROP_LEFT = "_prop_left_";
	 
	public static final String PROP_TEXT = "_prop_text_";
	 
	public static final String PROP_CHECKED = "_prop_checked_";
	 
	public static final String PROP_CLASSNAME = "_prop_className_";
	 
	public static final String PROP_ENABLE = "_prop_enable_";
	 
	public static final String PROP_TABINDEX = "_prop_tabIndex_";

	public CheckboxPropertySource(Checkbox checkbox) {
		super(checkbox);
	}
	
	protected void initialize() {
		descriptor = new PropertyDescriptor[] {
				  new MaskatTextPropertyDescriptor(PROP_NAME, "name"),
				  new MaskatTextPropertyDescriptor(PROP_LEFT, "left"),
				  new MaskatTextPropertyDescriptor(PROP_TOP, "top"),
				  new MaskatTextPropertyDescriptor(PROP_TABINDEX, "tabIndex"),
				  new MaskatTextPropertyDescriptor(PROP_TEXT, "text"),
				  new BooleanComboBoxPropertyDescriptor(PROP_ENABLE, "enable"),
				  new BooleanComboBoxPropertyDescriptor(PROP_CHECKED, "checked"),
				  new MaskatTextPropertyDescriptor(PROP_CLASSNAME, "className")};
		
		//make sure the "..." values are the same as bean's properties.
	    propMap.put(PROP_NAME, "name");
	    propMap.put(PROP_TOP, "top");
	    propMap.put(PROP_LEFT, "left");
	    propMap.put(PROP_TEXT, "text");
	    propMap.put(PROP_CHECKED, "checked");
	    propMap.put(PROP_CLASSNAME, "className");
	    propMap.put(PROP_ENABLE, "enable");
	    propMap.put(PROP_TABINDEX, "tabIndex");		
	}
}
