/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.layout.Button;
import org.maskat.ui.views.properties.descriptor.BooleanComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class ButtonPropertySource extends AbstractComponentPropertySource {

	public static final String PROP_NAME = "_prop_name_"; 
	
	public static final String PROP_LEFT = "_prop_left_";
	
	public static final String PROP_TOP = "_prop_top_";
	
	public static final String PROP_TITLE = "_prop_title_";
	
	public static final String PROP_ADAPT_TO_TEXT = "_prop_adapt_to_text_";

	public static final String PROP_ALT = "_prop_alt_";
	
	public static final String PROP_DRAGGABLE = "_prop_draggable_";
	
	public static final String PROP_ENABLE = "_prop_enable_";
	
	public static final String PROP_POSITION = "_prop_position_";
	
	public static final String PROP_TAB_INDEX = "_prop_tab_index_";
	
	public static final String PROP_WIDTH = "_prop_width_";
	
	public static final String PROP_WIDTH_MIN = "_prop_width_min_";
	
	public ButtonPropertySource(Button button) {
		super(button);
	}
	
	protected void initialize() {
		descriptor = new PropertyDescriptor[] {
				new MaskatTextPropertyDescriptor(PROP_NAME, "name"),
				new MaskatTextPropertyDescriptor(PROP_LEFT, "left"),
				new MaskatTextPropertyDescriptor(PROP_TOP, "top"),
				new MaskatTextPropertyDescriptor(PROP_WIDTH, "width"),
				new MaskatTextPropertyDescriptor(PROP_TAB_INDEX, "tabIndex"),
				new MaskatTextPropertyDescriptor(PROP_TITLE, "title"),
				new BooleanComboBoxPropertyDescriptor(PROP_ENABLE, "enable"),
				new MaskatTextPropertyDescriptor(PROP_ALT, "alt"),
				new BooleanComboBoxPropertyDescriptor(PROP_ADAPT_TO_TEXT, "adaptToText"),
				//new BooleanComboBoxPropertyDescriptor(PROP_DRAGGABLE, "draggable"),
				//new MaskatComboBoxPropertyDescriptor(PROP_POSITION, "position", ComboBoxLabelConstants.POSITION),
				new MaskatTextPropertyDescriptor(PROP_WIDTH_MIN, "widthMin") };
		
//		make sure the values are the same as bean's property.
		  propMap.put(PROP_NAME, "name");
		  propMap.put(PROP_LEFT, "left");
		  propMap.put(PROP_TOP, "top");
		  propMap.put(PROP_TITLE, "title");
		  propMap.put(PROP_ADAPT_TO_TEXT, "adaptToText");
		  propMap.put(PROP_ALT, "alt");
		  //propMap.put(PROP_DRAGGABLE, "draggable");
		  propMap.put(PROP_ENABLE, "enable");
		  //propMap.put(PROP_POSITION, "position");
		  propMap.put(PROP_TAB_INDEX, "tabIndex");
		  propMap.put(PROP_WIDTH, "width");
		  propMap.put(PROP_WIDTH_MIN, "widthMin");
	}

}
