/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.tools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.maskat.core.layout.Component;
import org.maskat.core.layout.Layout;
import org.maskat.core.layout.LayoutElement;

public class ComponentUtils {
	
	public static boolean isExistenceId(LayoutElement root, String id) {
		if (root instanceof Component) {
			if (id.equals(((Component) root).getName())) {
				return true;
			}
		}
		for (Iterator ite = root.getChildren(); ite != null && ite.hasNext();) {
			Object obj = ite.next();
			if (!(obj instanceof LayoutElement)) {
				continue;
			}
			if (obj instanceof Component) {
				if (id.equals(((Component) obj).getName())) {
					return true;
				}
			}
			boolean exist = isExistenceId((LayoutElement)obj, id);
			if (exist) {
				return true; 
			}
		}
		return false;
	}

	public static void setUniqueName(Layout layout, Component component) {
		setUniqueName(layout, component, new ArrayList());
	}
	
	private static void setUniqueName(Layout layout, Component component, List invalidList) {
		String name = component.getName();
		String newName = ComponentUtils.getUniqueName(layout, name, invalidList);
		if (!newName.equals(name)) {
			component.setName(newName);
		}
		Iterator ite = component.getTypedChildren(Component.class);
		while (ite != null && ite.hasNext()) {
			Component child = (Component) ite.next();
			setUniqueName(layout, child, invalidList);
		}
	}
	
	public static String getUniqueName(LayoutElement root, String baseName) {
		return getUniqueName(root, baseName, null);
	}

	public static String getUniqueName(LayoutElement root, String baseName, List invalidList) {
		ArrayList componentList = getAllComponentList(root);
		if (baseName == null) {
			baseName = "component"; //$NON-NLS-1$
			
		} else {
			if (!componentList.contains(baseName) && !invalidList.contains(baseName)) {
				invalidList.add(baseName);
				return baseName;
			}	
			for (int i = baseName.length() - 1; i >= 0; i--) {
				String id = baseName.substring(i, i + 1);
				try {
					Integer.parseInt(id);
				} catch (NumberFormatException e) {
					baseName = baseName.substring(0, i + 1);
					break;
				}
			}
		}
		for (int i = 0; i < Integer.MAX_VALUE; i++) {
			StringBuffer sb = new StringBuffer(baseName);
			if (i != 0) {
				sb.append(i);
			}
			if (!componentList.contains(sb.toString())) {	
				if (!invalidList.contains(sb.toString())) {
					invalidList.add(sb.toString());
					return sb.toString();
				}
			}
		}
		return null;
	}
	
	private static ArrayList getAllComponentList(LayoutElement element) {
		ArrayList list = new ArrayList();
		for (Iterator ite = element.getChildren(); ite != null && ite.hasNext();) {
			Object obj = ite.next();
			if (!(obj instanceof LayoutElement)) {
				continue;
			}
			if (obj instanceof Component) {
				list.add(((Component) obj).getName());
			}
			list.addAll(getAllComponentList((LayoutElement)obj));
		}
		return list;
	}
}
