/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.maskat.ui.ISharedImages;
import org.maskat.ui.MaskatUIPlugin;

public class RadioFigure extends Label {
	public static Font DEFAULT_FONT = new Font(null, "Arial", 8, 0);

	public RadioFigure(String text) {
		setForegroundColor(ColorConstants.black);
		setFont(DEFAULT_FONT);
		setLabelAlignment(PositionConstants.LEFT);
		setText(text);

		Image icon = MaskatUIPlugin.getImage(
				ISharedImages.IMG_RADIOUNCHECKED);
		
		setIcon(icon);
		setLayoutManager(new XYLayout());
	}
}
