/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editpolicies;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;

import org.maskat.core.MaskatElement;
import org.maskat.core.layout.TreeNode;
import org.maskat.core.layout.TreeView;
import org.maskat.ui.editors.layout.commands.AddBasicDefCommand;

public class TreeViewEditPolicy extends ComponentXYLayoutEditPolicy {
	
	public TreeViewEditPolicy() {}
	
	public TreeViewEditPolicy(int style) {
		setFeedBackStyle(style);
	}
	
	protected Command createAddCommand(EditPart child, Object constraint) {
		Object childModel = child.getModel();
		if (!(childModel instanceof TreeNode)) {
			return null;
		}

		MaskatElement host = (MaskatElement) getHost().getModel();
		TreeNode rootNode = (TreeNode) ((TreeView) host).getChildByTypeIdx(
				TreeNode.class, 0);

		if (rootNode != null) {
			// ルートノードのある場合、ルートノードに追加
			return new AddBasicDefCommand(rootNode, (TreeNode) childModel);
		}

		return new AddBasicDefCommand(host, (TreeNode) childModel);
	}

	protected Command getCreateCommand(CreateRequest request) {
		MaskatElement host = (MaskatElement) getHost().getModel();
		Object newObj = request.getNewObject();

		if (!(newObj instanceof TreeNode)) {
			return null;
		}
		TreeNode rootNode = (TreeNode) ((TreeView) host).getChildByTypeIdx(
				TreeNode.class, 0);

		if (rootNode != null) {
			// ルートノードのある場合、ルートノードに追加
			return new AddBasicDefCommand(rootNode, (TreeNode) newObj);
		}

		return new AddBasicDefCommand(host, (TreeNode) newObj);
	}

	protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
		return null;
	}
}
