/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editpolicies;

import java.util.Iterator;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

import org.maskat.core.layout.TabFolder;
import org.maskat.core.layout.TabItem;
import org.maskat.ui.editors.layout.commands.DelBasicDefCommand;
import org.maskat.ui.editors.layout.models.TabDef;

public class TabEditPolicy extends ComponentEditPolicy {

	protected Command createDeleteCommand(GroupRequest deleteRequest) {
		TabDef model = (TabDef) getHost().getModel();
//		TabItem model = (TabItem) getHost().getModel();

		
		TabFolder tabFolderDef = (TabFolder) model.getParent();
		Iterator it = tabFolderDef.getTypedChildren(TabItem.class);
		for (; it != null && it.hasNext();) {
			TabItem tabItemDef = (TabItem) it.next();
			if (model.getName().equals(tabItemDef.getName())) {
				return new DelBasicDefCommand(tabFolderDef, tabItemDef);
			}
		}
		return null;
	}
}
