/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editpolicies;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;

import org.maskat.core.layout.DivSplit;
import org.maskat.core.layout.Grid;
import org.maskat.core.layout.GridHeader;
import org.maskat.core.layout.Component;
import org.maskat.core.layout.Container;
import org.maskat.core.layout.Layout;
import org.maskat.core.layout.LayoutElement;
import org.maskat.ui.editors.layout.commands.DelBasicDefCommand;
import org.maskat.ui.editors.layout.commands.DelGridHeaderCommand;

public class MaskatComponentEditPolicy extends ComponentEditPolicy {

	protected Command createDeleteCommand(GroupRequest deleteRequest) {
		Object model = getHost().getModel();
		if (model instanceof GridHeader) {
//			Grid grid = ((GridHeader) model).getGrid();
			Grid grid = (Grid) ((LayoutElement) model).getParent();
			return new DelGridHeaderCommand(grid, (GridHeader) model);
		}
		if (model instanceof Component) {
			Component comp = (Component) model;
			if (comp instanceof Layout) {
				return null;
			}
			if (comp instanceof DivSplit) {
				return null;
			}
			return new DelBasicDefCommand(comp.getParent(), comp);
		}
		return null;
	}

	protected boolean canFeedbackToRequest(Request request) {
		Object model = getHost().getModel();
		if (model instanceof Container && !(model instanceof Layout)) {
			return true;
		}
		return false;
	}

	public void showTargetFeedback(Request request) {
		if (canFeedbackToRequest(request)) {
			// TODO ChangeBoundsRequestの場合、EditPartは親EditPart内移動する場合、
			// ハイライト表示はしないように
			boolean doHighlight = false;
			if (request instanceof CreateRequest
					|| request instanceof ChangeBoundsRequest) {
				doHighlight = true;
			}
			if (doHighlight) {
				// ハイライト表示
				((AbstractGraphicalEditPart) getHost()).getFigure().setBackgroundColor(
						ColorConstants.lightGray);
				((AbstractGraphicalEditPart) getHost()).getFigure().setOpaque(true);
			}
		}
		super.showTargetFeedback(request);
	}

	public void eraseTargetFeedback(Request request) {
		if (canFeedbackToRequest(request)) {
			if (request instanceof CreateRequest
					|| request instanceof ChangeBoundsRequest) {
				((AbstractGraphicalEditPart) getHost()).getFigure().setBackgroundColor(
						ColorConstants.white);
				((AbstractGraphicalEditPart) getHost()).getFigure().setOpaque(false);
			}
		}
		super.eraseTargetFeedback(request);
	}
}
