/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editparts;

import java.beans.PropertyChangeEvent;
import java.util.List;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;

import org.maskat.core.MaskatElement;
import org.maskat.core.layout.Component;
import org.maskat.core.layout.Layout;
import org.maskat.ui.editors.layout.commands.AddComponentCommand;
import org.maskat.ui.editors.layout.figures.WindowFigure;

public class WindowEditPart extends ComponentEditPart {
	
	protected IFigure createFigure() {
		return new WindowFigure();
	}
	
	public void setModel(Object model) {
		if (model instanceof Component) {
			((Component) model).setConstraint(0, 0, 0, 0);
		}
		super.setModel(model);
	}

	public Command createConstrainCommand(Object model, Rectangle constraint) {
		return null;
	}

	public Command getCreateCommand(Object parent, Object node) {
		if (parent instanceof Layout) {
			return  new AddComponentCommand((Component) parent, (Component) node);
		}
		return null;
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("addChild".equals(evt.getPropertyName()) ||
			"removeChild".equals(evt.getPropertyName())) {
			refresh();
		}
		super.propertyChange(evt);
	}
	
	protected void refreshVisuals() {
		Rectangle constraint = ((GraphicalEditPart)
			this.getViewer().getRootEditPart()).getFigure().getBounds();
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}
	
	protected List getModelChildren() {
		List result = null;
		if (getModel() instanceof MaskatElement) {
			result = ((MaskatElement) getModel()).getUnmodifiableChildren();
		}
		return (result != null) ? result : super.getModelChildren(); 
	}
}
