/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editparts;

import java.beans.PropertyChangeEvent;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;

import org.maskat.core.layout.Checkbox;
import org.maskat.core.layout.Component;
import org.maskat.ui.editors.layout.figures.CheckBoxFigure;

public class CheckBoxEditPart extends ComponentEditPart
	implements LabelDirectEditable {

	protected IFigure createFigure() {
		Checkbox model = (Checkbox) getModel();
		IFigure figure = new CheckBoxFigure(model.getText());
		return figure;
	}

	protected void refreshVisuals() {
		Component comp = (Component) getModel();
		Dimension d = getFigure().getPreferredSize();
		
		Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(), d.width,
				d.height);
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("text".equals(evt.getPropertyName())) {
			((CheckBoxFigure) getFigure()).setText((String) evt.getNewValue());
		}
//		refreshVisuals();
		super.propertyChange(evt);
	}

	public String getLabel() {
		return ((Checkbox) getModel()).getText();
	}

	public void setLabel(String text) {
		((Checkbox) getModel()).setText(text);
	}
}
