/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class MaskatUIPlugin extends AbstractUIPlugin
	implements ISharedImages {

	/** The shared instance. */
	private static MaskatUIPlugin plugin;

	/** The plug-in ID */
	public static final String PLUGIN_ID = "org.maskat.ui"; //$NON-NLS-1$

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * The constructor.
	 */
	public MaskatUIPlugin() {
		super();
		plugin = this;
	}

	/**
	 * Returns the shared instance.
	 */
	public static MaskatUIPlugin getDefault() {
		return plugin;
	}

	protected void initializeImageRegistry(ImageRegistry reg) {
		reg.put(IMG_COMPONENT_LAYOUT, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/layout.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_BUTTON, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/button.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_CHECKBOX, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/checkbox.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_CODELIB, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/codelib.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_COMBO, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/combo.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_COMBOITEM, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/comboitem.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_DIVHTML, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/divhtml.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_FRAME, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/frame.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_WINDOW, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/window.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_GRID, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/grid.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_GRIDHEADER, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/gridheader.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_IMAGE, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/image.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_LABEL, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/label.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_POPUP, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/popup.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_RADIO, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/radio.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_SPLITTER, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/splitter.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_TABFOLDER, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/tabfolder.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_TABITEM, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/tabitem.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_TEXT, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/text.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_TREE, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/tree.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_TREENODE, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/treenode.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_CUSTOM, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/custom.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_UNKNOWN, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/unknown_obj.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_GRIDLINE, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/treenode.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_GRIDCELL, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/treenode.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_GRIDCELLCOMBO, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/treenode.gif")); //$NON-NLS-1$
		
		reg.put(IMG_COMPONENTICON, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/componenticon.gif")); //$NON-NLS-1$
		reg.put(IMG_CHECKBOXUNCHECKED, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/checkboxenabledoff.gif")); //$NON-NLS-1$
		reg.put(IMG_RADIOUNCHECKED, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/radioboxenableoff.gif")); //$NON-NLS-1$
		reg.put(IMG_COMBOBOXDROPDOWN, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/comboboxdropdown.gif")); //$NON-NLS-1$
		reg.put(IMG_CODELIBBUTTON, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/codelibbutton.gif")); //$NON-NLS-1$		

		reg.put(IMG_OBJ_ELEMENT, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/obj16/element.gif")); //$NON-NLS-1$		

		reg.put(IMG_HORIZONTAL_ACTION, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/th_horizontal.gif")); //$NON-NLS-1$
		reg.put(IMG_VERTICAL_ACTION, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/th_vertical.gif")); //$NON-NLS-1$
		reg.put(IMG_WIZBAN_NEWPROJECT, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/wizban/newprj_wiz.png")); //$NON-NLS-1$
		reg.put(IMG_WIZBAN_NEWAPPLICATION, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/wizban/newapp_wiz.png")); //$NON-NLS-1$
		reg.put(IMG_WIZBAN_NEWFILE, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/wizban/newfile_wiz.png")); //$NON-NLS-1$
		reg.put(IMG_WIZBAN_MASKATFILE, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/wizban/maskatfile.gif")); //$NON-NLS-1$
		reg.put(IMG_WIZBAN_HTMLFILE, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/wizban/containerhtml.gif")); //$NON-NLS-1$
	}

	public static ImageDescriptor getImageDescriptor(IConfigurationElement element,
			String attributeName) {
		String path = element.getAttribute(attributeName);
		if (path == null) {
			return null;
		}
		String pluginId = element.getDeclaringExtension().getNamespaceIdentifier();
		return AbstractUIPlugin.imageDescriptorFromPlugin(pluginId, path);
	}

	public static Image getImage(String key) {
		return getDefault().getImageRegistry().get(key);
	}

	public static ImageDescriptor getImageDescriptor(String key) {
		return getDefault().getImageRegistry().getDescriptor(key);
	}

	public static void log(IStatus status) {
		getDefault().getLog().log(status);
	}

}
