/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;

public class WindowBeanInfo extends SimpleBeanInfo {

	public PropertyDescriptor[] getPropertyDescriptors() {
		PropertyDescriptor[] descs = null;
		PropertyDescriptor[] WindowDefPropDesc = null;
		// 親クラスのBeanInfo
		try {
			BeanInfo info = Introspector.getBeanInfo(AbstractContainer.class);
			descs = info.getPropertyDescriptors();
			WindowDefPropDesc = new PropertyDescriptor[] {
					new PropertyDescriptor("title", Window.class),
					new PropertyDescriptor("icone", Window.class),
					new PropertyDescriptor("style", Window.class)};
					//new PropertyDescriptor("bWithoutPlaceIn", Window.class),
					//new PropertyDescriptor("withCloseButon", Window.class),
					//new PropertyDescriptor("autoResizableH", Window.class),
					//new PropertyDescriptor("autoResizableW", Window.class),
					//new PropertyDescriptor("position", Window.class) };
		} catch (IntrospectionException e) {
			return null;
		}

		// Window自身のPropertyDescriptor[]を追加
		PropertyDescriptor[] result = new PropertyDescriptor[descs.length
				+ WindowDefPropDesc.length];
		System.arraycopy(descs, 0, result, 0, descs.length);
		System.arraycopy(WindowDefPropDesc, 0, result, descs.length,
				WindowDefPropDesc.length);
		return result;
	}
}
