/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import java.util.Iterator;

public class TabFolder extends AbstractStructuredComponent {
	
	public static final String POSITION_DEFAULT = "absolute";
	
	public static final String ORIENTATION_DEFAULT = "t";
	
	public static final int WIDTH_TAB_NAME_DEFAULT = 100;
	
	public static final int NO_ACTIVE_TAB_DEFAULT = 1;
	
	public static final boolean IS_CLOSABLE_DEFAULT = true;
	
//	public static final boolean ENABLE_DEFAULT = true;
	
	public static final boolean AUTO_REDIM_TAB_DEFAULT = false;
	
//	public static final boolean AUTO_RESIZE_PARENT_DEFAULT = false;
//	
//	public static final boolean AUTO_RESIZE_CONTENU_DEFAULT = false;
//	
	public static final boolean AUTO_RESIZABLE_H_DEFAULT = false;
	
	public static final boolean AUTO_RESIZABLE_W_DEFAULT = false;
	
	public static final boolean DRAGGABLE_DEFAULT = false;
	
	public static final boolean DRAGGABLE_ITEM_DEFAULT = false;
	
	public static final int TABINDEX_DEFAULT = -1;


	private int widthTabName = WIDTH_TAB_NAME_DEFAULT;

	private int noActiveTab = NO_ACTIVE_TAB_DEFAULT;

	private boolean autoRedimTab = AUTO_REDIM_TAB_DEFAULT;

	private boolean draggableItem = DRAGGABLE_ITEM_DEFAULT;

//	private boolean autoResizeParent = AUTO_RESIZE_PARENT_DEFAULT;

	private boolean isClosable = IS_CLOSABLE_DEFAULT;

//	private boolean autoResizeContenu = AUTO_RESIZE_CONTENU_DEFAULT;
	
	private boolean draggable = DRAGGABLE_DEFAULT;
	
//	private boolean enable = ENABLE_DEFAULT;
	
	private boolean autoResizableH = AUTO_RESIZABLE_H_DEFAULT;
	
	private boolean autoResizableW = AUTO_RESIZABLE_W_DEFAULT;
	
	private String position = POSITION_DEFAULT;
	
	private String orientation = ORIENTATION_DEFAULT;

	public TabFolder() {
		setTabIndex(TABINDEX_DEFAULT);
	}
	
	public int getTabIdxByName(String name) {
		Iterator tabIts = this.getTypedChildren(TabItem.class);
		if (tabIts == null) {
			return -1;
		}
		int result = 0;
		while (tabIts.hasNext()) {
			if (name.equals(((TabItem) tabIts.next()).getName())) {
				return result;
			}
			result++;
		}
		return -1;
	}

	public boolean isAutoRedimTab() {
		return autoRedimTab;
	}

	public void setAutoRedimTab(boolean autoRedimTab) {
		this.autoRedimTab = autoRedimTab;
	}

//	public boolean isAutoResizeParent() {
//		return autoResizeParent;
//	}
//
//	public void setAutoResizeParent(boolean autoResizeParent) {
//		this.autoResizeParent = autoResizeParent;
//	}

	public boolean isDraggableItem() {
		return draggableItem;
	}

	public void setDraggableItem(boolean draggableItem) {
		this.draggableItem = draggableItem;
	}

	public boolean isIsClosable() {
		return isClosable;
	}

	public void setIsClosable(boolean isClosable) {
		this.isClosable = isClosable;
	}

	public int getNoActiveTab() {
		return noActiveTab;
	}

	public void setNoActiveTab(int noActiveTab) {
		this.noActiveTab = noActiveTab;
	}

	public int getWidthTabName() {
		return widthTabName;
	}

	public void setWidthTabName(int widthTabName) {
		int oldWidthTabName = this.widthTabName;
		this.widthTabName = widthTabName;		
		firePropertyChange("widthTabName", String.valueOf(oldWidthTabName), String.valueOf(widthTabName));
	}

//	public boolean isAutoResizeContenu() {
//		return autoResizeContenu;
//	}
//
//	public void setAutoResizeContenu(boolean autoResizeContenu) {
//		this.autoResizeContenu = autoResizeContenu;
//	}

	public boolean isAutoResizableH() {
		return autoResizableH;
	}

	public void setAutoResizableH(boolean autoResizableH) {
		this.autoResizableH = autoResizableH;
	}

	public boolean isAutoResizableW() {
		return autoResizableW;
	}

	public void setAutoResizableW(boolean autoResizableW) {
		this.autoResizableW = autoResizableW;
	}

	public boolean isDraggable() {
		return draggable;
	}

	public void setDraggable(boolean draggable) {
		this.draggable = draggable;
	}

//	public boolean isEnable() {
//		return enable;
//	}
//
//	public void setEnable(boolean enable) {
//		this.enable = enable;
//	}

	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}

	public String getOrientation() {
		return orientation;
	}

	public void setOrientation(String orientation) {
		this.orientation = orientation;
	}

	public boolean canAddPart(ComponentPart child) {
		return (child instanceof TabItem);
	}
}
