/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

/**
 * Instance of this class corresponds to radioGroup node.
 * This class mainly functions when loading layout definition and writing object
 * to layout definition. Other than than this class should of no use to the IDE.
 * "radioGroup" node which is not a direct child of "layout" node will be deemed
 * as
 */
public class RadioGroup extends AbstractLayoutElement {

	private String name;

	private int tabIndex;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getTabIndex() {
		return tabIndex;
	}

	public void setTabIndex(int tabIndex) {
		this.tabIndex = tabIndex;
	}

	public void addMember(String ref) {
		RadioMember member = new RadioMember();
		member.setRef(ref);
		addChild(member);
	}
}
