/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import java.util.ArrayList;
import java.util.List;

public class GridLine extends AbstractLayoutElement implements ComponentPart {

	private List cells;

	public List getCells() {
		return cells;
	}

	public void setCells(List cells) {
		this.cells = cells;
	}

	private void addCell(GridCell cell) {
		if (cells == null) {
			cells = new ArrayList();
		}
		cells.add(cell);
	}

	public void addChild(Object comp) {
		super.addChild(comp);
		if (comp instanceof GridCell) {
			addCell((GridCell) comp);
		}
	}
}
