/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import org.maskat.core.event.EventTypeConstants;

public class Combo extends AbstractStructuredComponent {
	
	public static final String POSITION_DEFAULT = "relative";
	
	public static final boolean ENABLE_DEFAULT = true;
	
	public static final boolean SUGGEST_DEFAULT = true;
	
	public static final int HEIGHT_ITEM_DEFAULT = 0;
	
	public static final int TABINDEX_DEFAULT = -1;

	private int heightItem = HEIGHT_ITEM_DEFAULT;

	private boolean enable = ENABLE_DEFAULT;

	private String tabData;

	private boolean suggest = SUGGEST_DEFAULT;
	
	private String position = POSITION_DEFAULT;
	
	private int tabIndex = TABINDEX_DEFAULT;

	public boolean isEnable() {
		return enable;
	}

	public void setEnable(boolean enable) {
		this.enable = enable;
	}

	public int getHeightItem() {
		return heightItem;
	}

	public int calcHeightItemInt() {
//		return CUtil.safeToInt(heightItem);
		return heightItem;
	}

	public void setHeightItem(int heightItem) {
		this.heightItem = heightItem;
	}

	public boolean isSuggest() {
		return suggest;
	}

	public void setSuggest(boolean suggest) {
		this.suggest = suggest;
	}

	public String getTabData() {
		return tabData;
	}

	public void setTabData(String tabData) {
		this.tabData = tabData;
	}

	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}

	public int getTabIndex() {
		return tabIndex;
	}

	public void setTabIndex(int tabIndex) {
		this.tabIndex = tabIndex;
	}

	public void addChild(Object comp) {
		super.addChild(comp);
		firePropertyChange("addChild", "", null);
	}

	public void addChildToIdx(Object child, int idx) {
		super.addChildToIdx(child, idx);
		firePropertyChange("addChild", "", null);
	}

	public void removeChild(Object obj) {
		super.removeChild(obj);
		firePropertyChange("removeChild", "", null);
	}
	
	public String[] getEventTypes() {
		return new String[] {
				EventTypeConstants.ON_CLICK,
				EventTypeConstants.ON_BLUR};
	}

	public boolean canAddPart(ComponentPart child) {
		return (child instanceof ComboItem);
	}
}
