/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

public class CodeLib extends AbstractComponent {
	
	public static final int CODE_WIDTH_DEFAULT = 50;
	
	public static final boolean ENABLE_DEFAULT = true;
	
	public static final boolean SUBMIT_ONLOAD_DEFAULT = true;
	
	public static final boolean BOOL_WITH_LABEL_DEFAULT = true;

	public static final boolean ALWAYS_REFRESH_DEFAULT = false;

	public static final int TABINDEX_DEFAULT = -1;
	
	private String url;

	private boolean boolWithLabel = BOOL_WITH_LABEL_DEFAULT;

	private String arrValue;

	private boolean submitOnload = SUBMIT_ONLOAD_DEFAULT;

	private boolean alwaysRefresh = ALWAYS_REFRESH_DEFAULT;

	private int codeWidth = CODE_WIDTH_DEFAULT;

	private boolean enable = ENABLE_DEFAULT;

	public CodeLib() {
		setTabIndex(TABINDEX_DEFAULT);
	}
	
	public boolean hasLabelInput() {
//		return "true".equalsIgnoreCase(boolWithLabel);
		return boolWithLabel;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public boolean isBoolWithLabel() {
		return boolWithLabel;
	}

	public void setBoolWithLabel(boolean withLabelInput) {
		boolean old = this.boolWithLabel;
		this.boolWithLabel = withLabelInput;
		firePropertyChange("boolWithLabel", String.valueOf(old), String.valueOf(withLabelInput));
	}

	public boolean isAlwaysRefresh() {
		return alwaysRefresh;
	}

	public void setAlwaysRefresh(boolean alwaysRefresh) {
		this.alwaysRefresh = alwaysRefresh;
	}

	public String getArrValue() {
		return arrValue;
	}

	public void setArrValue(String arrValue) {
		this.arrValue = arrValue;
	}

	public int getCodeWidth() {
		return codeWidth;
	}

	public void setCodeWidth(int codeWidth) {
		this.codeWidth = codeWidth;
	}

	public boolean isSubmitOnload() {
		return submitOnload;
	}

	public void setSubmitOnload(boolean submitOnload) {
		this.submitOnload = submitOnload;
	}

	public boolean isEnable() {
		return enable;
	}

	public void setEnable(boolean enable) {
		this.enable = enable;
	}

}
