/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

public abstract class AbstractStructuredComponent extends AbstractComponent implements
		StructuredComponent {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IContainerDef#addChild(java.lang.Object)
	 */
	public void addChild(Object comp) {
		super.addChild(comp);
		firePropertyChange("addChild", "", null);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IContainerDef#removeChild(java.lang.Object)
	 */
	public void removeChild(Object obj) {
		super.removeChild(obj);
		firePropertyChange("removeChild", "", null);
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IContainerDef#addChildToIdx(java.lang.Object,
	 *      int)
	 */
	public void addChildToIdx(Object comp, int idx) {
		super.addChildToIdx(comp, idx);
		firePropertyChange("addChild", "", null);
	}
	
	public abstract boolean canAddPart(ComponentPart child);

}
