/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.event;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.maskat.core.DefChildIterator;

public class Component extends AbstractEventElement {
	
	private String id;

	private Map events;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public void addChild(Object child) {
		super.addChild(child);
		if (child instanceof Event) {
			addEvent((Event) child);
		}
	}

	private void addEvent(Event event) {
		if (events == null) {
			events = new HashMap();
		}
		events.put(event.getId(), event);
	}

	public Event removeEvent(String id) {
		return (Event) events.remove(id);
	}

	public Event findEvent(String id) {
		return (events == null) ? null : (Event) events.get(id);
	}

	public boolean hasEvents() {
		return (events == null || events.size() == 0) ? false : true;
	}
	
	public boolean hasEnabledEvents() {
		if (events == null) {
			return false;
		}
		Iterator it = events.values().iterator();
		while (it != null && it.hasNext()) {
			if (((Event)it.next()).isEnable()) {
				return true;
			}
		}
		return false;
	}

	public Iterator getAllEvents() {
		if (events == null) {
			return null;
		}
		return new DefChildIterator(this, events.values().iterator());
	}
}
