/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.xml.DocumentBinding", {

	/**
	 * コンストラクタ
	 *
	 * @param binder このバインディングを使用する XMLObjectBinder
	 * @param uri ルート要素の名前空間 URI
	 * @param name ルート要素のローカル名
	 */
	initialize: function(binder, uri, name) {
		this.binder = binder;
		this.setRootElement(uri, name);
	},

	/**
	 * XML 文書のルート要素を設定します。
	 *
	 * @param uri ルート要素の名前空間 URI
	 * @param name ルート要素のローカル名
	 */
	setRootElement: function(uri, name) {
		this.uri = uri || "";
		this.name = name;
	},

	/**
	 * XML 文書の情報をオブジェクトに読み込み、そのオブジェクトを返します。
	 *
	 * @param doc XML 文書
	 *
	 * @return XML 文書の情報を読み込んだオブジェクト
	 */
	read: function(doc) {
		var element = doc.documentElement;
		var nodeName = element.localName || element.baseName;
		if (nodeName != this.name) {
			throw new maskat.lang.Error("INVALID_ROOT_NODE",
				{ elementName: nodeName });
		}
		
		var binding = this.binder.getElementBinding(element);
		return binding.read(null, element);
	},

	/**
	 * オブジェクトを XML 文書の形式で文字列バッファに書き出します。
	 *
	 * @param object オブジェクト
	 * @param buffer 文字列バッファ
	 */
	write: function(object, buffer) {
		buffer.push("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
		var binding = this.binder.getElementBinding(this.uri, this.name);
		binding.write(object, buffer);
	}

});
