/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.util.Message", {

	_static: {
		templates: {
			"CREATEXHR_ERROR": "XMLHttpRequestが生成できません。\n#{agent}",
			"HTTP_403": "HTTP #{status} - 指定されたURLにアクセスする権限がありません。\n#{url}",
			"HTTP_404": "HTTP #{status} - 指定されたURLは見つかりません。\n#{url}",
			"HTTP_500": "HTTP #{status} - 内部サーバエラーが発生しました。\n#{url}",
			"HTTP_ERROR": "サーバとの通信に失敗しました。\nサーバが落ちている可能性があります。",
			"HTTP_DEFAULT": "HTTP #{status} - サーバとの通信に失敗しました。\n#{url}",
			"PARSEERROR_IE": "#{msg} 行番号: #{line}  列番号:#{pos} #{text}",
			"PARSEERROR_DEFAULT" : "#{msg}",
			"UNDEFINED_VARIABLE": "レイアウト #{layoutId} に変数 #{name} が宣言されていません。",
			"DUPLICATED_VARIABLE": "レイアウト #{layoutId} に変数 #{name} がすでに宣言されています。",
			"MISSING_WIDGET": "レイアウト #{layoutId} にマスカット部品 #{widgetId} が定義されていません。",
			"REQUEST_BIND_ERROR" : "要求メッセージのデータバインドに失敗しました。widgetId=#{widgetId}, eventType=#{type}",
			"RESPONSE_BIND_ERROR" : "応答メッセージのデータバインドに失敗しました。widgetId=#{widgetId}, eventType=#{type}",
			"RESPONSE_TIMEOUT" : "タイムアウトが発生しました。widgetId=#{widgetId}, eventType=#{type}",
			"INTERRUPTION_ERROR": "ユーザ定義関数によりイベント処理が停止されました。",
			"SYNC_EVENT_IN_PROGRESS": "通信中です。しばらくお待ちください...",
			"XML_LOAD_ERROR": "XML の読み込みに失敗しました: #{url}",
			"ELEMENT_READ_ERROR": "#{elementName} 要素の読み込みに失敗しました。",
			"UNKNOWN_NS_URI": "未知の名前空間 URI です: #{uri}",
			"UNKNOWN_ELEMENT": "未知の XML 要素です: #{elementName}",
			"ATTRIBUTE_READ_ERROR": "#{elementName} 要素の属性 #{attributeName} の読み込みに失敗しました。",
			"MISSING_ATTRIBUTE": "必須属性 #{attributeName} が定義されていません。",
			"UNKNOWN_ATTRIBUTE": "#{elementName} 要素に未知の属性 #{attributeName} が定義されています。",
			"MISSING_FUNCTION": "関数 #{functionName} は定義されていません。",
			"INVALID_CHILD_ELEMENT": "#{childName} は #{elementName} の子要素にすることはできません。",
			"INVALID_ROOT_NODE": "#{elementName} は無効なルートノードです。",
			"MISSING_CHILD_ELEMENT": "#{elementName} 要素の子要素 #{childName} を省略することはできません。",
			"DUPLICATED_CHILD_ELEMENT": "#{elementName} 要素に子要素 #{childName} を複数回定義することはできません。",
			"LOG_FACTORY_INIT_FAILED": "ログファクトリの初期化に失敗しました: #{className}",
			"UNKNOWN_CONVERTER_TYPE": "未知のデータ型です。 #{type}",
			"CONVERTER_ERROR": "データ型の変換に失敗しました。データ型: #{type}, 値: #{value}"
		},

		loadTemplates: function(url) {
			maskat.lang.Object.populate(this.templates,
				maskat.util.CrossBrowser.loadJSONFrom(url)); 
		},

		format: function(key, values) {
			var template = this.templates[key];
			if (values && template) {
				replacer = function(str, p1, offset, s){ return values[p1]; };
				template = template.replace(/#{(.*?)}/g, replacer);
			}
			return template;
		}
	}

});
