/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.ui.Dialog", {

	_static: {
	
		/* ダイアログ戻り値の宣言 */
		YES: "YES",
		NO: "NO",
		OK: "OK",
		CANCEL: "CANCEL",
		
		/* アイコンURLの宣言 */
		INFO: "/rialto/rialtoEngine/images/debug/infoIcon.png",
		WARN: "/rialto/rialtoEngine/images/debug/warningIcon.png",
		ERROR:"/rialto/rialtoEngine/images/debug/errorIcon.png",
		
		/**
		 * Dialogの生成に用いるDialogFactoryを取得します。
		 *
		 * @return Dialogファクトリ
		 */
		getFactory: function() {
			/* 取得済みの場合はそれを返却する */
			if (this.factory) {
				return this.factory;
			}

			var className;
			var type;		
			try {
				/* プロパティで指定されたダイアログファクトリを取得 */　
				className = maskat.app.getProperty("maskat.ui.dialog.factory");
				type = maskat.util.Converter.convert("function", className);
				this.factory = type.getInstance();
			} catch (e) {
				var logger = maskat.log.LogFactory.getLog("maskat.ui");
				logger.error(e.getMessages ? e.getMessages().join("\n") : e.message);
			}
			/* 取得できなかった場合 */
			if (!this.factory) {
				alert("DialogFactoryが取得できません");
			}
			return this.factory;
		},
		
		/**
		 * 確認ダイアログをPOPUPして表示します。
		 *
		 * @param title ダイアログのタイトル文字列
		 * @param message ダイアログメッセージ文字列
		 * @param icon アイコン種別
		 * @param onClick ボタン押下時の呼び出し関数
		 */
		openMessage: function (title, message, icon, onClick)  {

			this.dialog = null;
			/* 未取得の場合は取得する */
			if (!this.factory) {
				this.getFactory();
			}
			/* 取得できなかった場合 */
			if (!this.factory) {
				return;
			}
			
			/* メッセージ表示クラスをファクトリ経由で生成 */
			this.dialog = 
				this.factory.createMessage (title, message, icon, onClick);
			
			/* 取得できなかった場合 */
			if (!this.dialog) {
				return;
			}
			/* メッセージの表示を実行 */
			this.dialog.open ();
			
			return this.dialog;
		},
		
		/**
		 * 入力ダイアログをPOPUPして表示します。
		 *
		 * @param title ダイアログのタイトル文字列
		 * @param message ダイアログメッセージ文字列
		 * @param icon アイコン種別
		 * @param onClick ボタン押下時の呼び出し関数
		 */
		openInput: function (title, message, icon, onClick) {
			this.dialog = null;
			/* 未取得の場合は取得する */
			if (!this.factory) {
				this.getFactory();
			}
			/* 取得できなかった場合 */
			if (!this.factory) {
				return;
			}
			
			/* 入力ダイアログクラスをファクトリ経由で生成 */
			this.dialog = 
				this.factory.createInput (title, message, icon, onClick);
			
			/* 取得できなかった場合 */
			if (!this.dialog) {
				return;
			}
			/* メッセージの表示を実行 */
			this.dialog.open ();

			return this.dialog;
		},
		
		/**
		 * アラートをPOPUPして表示します。
		 *
		 * @param title ダイアログのタイトル文字列
		 * @param message ダイアログメッセージ文字列
		 * @param icon アイコン種別
		 * @param onClick ボタン押下時の呼び出し関数
		 */
		openAlert: function (title, message, icon, onClick) {
			this.dialog = null;
			/* 未取得の場合は取得する */
			if (!this.factory) {
				this.getFactory();
			}
			/* 取得できなかった場合 */
			if (!this.factory) {
				return;
			}
			
			/* アラート表示ダイアログクラスをファクトリ経由で生成 */
			this.dialog = 
				this.factory.createAlert (title, message, icon, onClick);
			
			/* 取得できなかった場合 */
			if (!this.dialog) {
				return;
			}
			/* メッセージの表示を実行 */
			this.dialog.open ();

			return this.dialog;
		},
		
		/**
		 * 進捗状況ウィンドウをPOPUPして表示します。
		 *
		 * @param title ダイアログのタイトル文字列
		 * @param message ダイアログメッセージ文字列
		 * @param goalValue 終了進捗値(オプション)
		 * @return POPUPのインスタンス
		 */
		openProgress: function (title, message, goalValue)  {
			this.dialog = null;
			/* 未取得の場合は取得する */
			if (!this.factory) {
				this.getFactory();
			}
			/* 取得できなかった場合 */
			if (!this.factory) {
				return;
			}
			
			/* 進捗表示ダイアログクラスをファクトリ経由で生成 */
			this.dialog = 
				this.factory.createProgress (title, message, goalValue);
			
			/* 取得できなかった場合 */
			if (!this.dialog) {
				return;
			}
			/* メッセージの表示を実行 */
			this.dialog.open ();
			
			return this.dialog;
		}
	}
});
