/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * LiveValidation プラグインのPluginクラスです。
 */
maskat.lang.Class.declare(
	"maskat.validator.livevalidation.LiveValidationPlugin")
	.extend("maskat.core.Plugin", {
	
	_static: {
		initialize: function() {
			maskat.core.Plugin.register(this);
		}
	},
	
	/**
	 * プラグイン識別子を返します。
	 * 
	 * @return プラグイン識別子
	 */
	getPluginId: function() {
		return "livevalidation";
	},

	/**
	 * プラグインのバージョン識別子を返します。
	 * 
	 * @return プラグインのバージョン識別子
	 */
	getVersion: function() {
		return "1.0.0.v20080521";
	},

	/**
	 * プラグインのロードが完了したかどうかを返します。
	 * 
	 * このメソッドが true を返すまでマスカットアプリケーションの実行は
	 * 開始しません。
	 * 
	 * @return ロードが完了していれば true、それ以外の場合は false
	 */
	isLoaded: function() {
		return this.loaded;
	},
	
	/**
	 * プラグインに必要なリソースをロードします。
	 * 
	 * @param app このプラグインを使用するマスカットアプリケーション
	 */
	load: function() {
		maskat.app.loadJavaScript(
			maskat.location + "livevalidation/livevalidation_standalone.js", false);
		this.setupLoadValidationCommand();
		this.loaded = true;
	},
	
	/**
	 * LiveValidation プラグインの実行を開始します。
	 */
	start: function() {
	
		// LiveValidation用のCSS定義を優先させるため、
		// start 内でスタイルシートをロードする。
		maskat.app.loadStyleSheet(
			maskat.location + "livevalidation/css/livevalidation_plugin.css");
	
		// LiveValidationライブラリのロード後に派生クラスへの継承処理を行う。
		var baseValidator =
			maskat.validator.livevalidation.custom.CustomLiveValidation;
		baseValidator.inherit(LiveValidation, baseValidator.properties); 
		
		// LiveValidation プラグインのメッセージ定義をロードする。
		maskat.util.Message.loadTemplates(
			maskat.location + "livevalidation/messages.json");
	},
	
	/**
	 * 画面遷移定義XMLでloadValidationタグを使用するための設定を行います。
	 */
	setupLoadValidationCommand: function() {
		var tagName = "loadValidation";
		var child = { property: "commands", repeat: true };
		var element = {
			type: maskat.validator.livevalidation.control.LoadValidationCommand,
			attributes: {
				xmlFile: {	type: "string",	required: true,	property: "url"	}
			}
		};

		var reader = maskat.control.TransitionXMLReader.getInstance(); 
		reader.addElementBinding("", tagName, element);
		
		var init = reader.getElementBinding("", "init");
		init.addChildBinding(tagName, child);
		
		var transition = reader.getElementBinding("", "transition");
		transition.addChildBinding(tagName, child);
	}
});
