/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.compat.Maskat14SupportPlugin")
	.extend("maskat.core.Plugin", {

	_static: {
		initialize: function() {
			maskat.core.Plugin.register(this);
		}
	},

	getPluginId: function() {
		return "compat";
	},

	getVersion: function() {
		return "1.0.0.v20080521";
	},

	getDependencies: function() {
		return [ "rialto", "html" ];
	},

	isLoaded: function() {
		return this.loaded;
	},

	load: function() {
		this.loaded = true;

		if (window.onload) {
			this.onload = window.onload;
			window.onload = null;
			try {
				delete window.onload;
			} catch (e) { /* suppress */ }
		}
	},

	start: function() {
		var reader = maskat.layout.LayoutXMLReader.getInstance();
		reader.addWidgetLibrary(new maskat.layout.LayoutFactory());
		reader.addWidgetLibrary(new maskat.widget.compat.CompatWidgetLibrary());

		maskat.layouts = maskat.app.layouts;

		if (this.onload) {
			this.onload();
		}
	}

});
