﻿/*
 * Copyright (c) 2007 NTT DATA CORPORATION
 *
 * This software is the confidential and proprietary information of
 * NTT DATA CORPORATION. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with NTT DATA
 */

maskat.syntax.colorPanel = {};
maskat.syntax.colorPanel.name = {type: "string"};
maskat.syntax.colorPanel.top = {type: "number"};
maskat.syntax.colorPanel.left = {type: "number"};
maskat.syntax.colorPanel.width = {type: "number"};
maskat.syntax.colorPanel.height = {type: "number"};
maskat.syntax.colorPanel.color = {type: "string"};
maskat.syntax.colorPanel.parent = {type: "object"};

maskat.transColorPanelTag = function(pathObjArray, domElem){
  var output = "";
  var attr = {};

  maskat.receiveAttributes(domElem, attr);

  var refObjName;
  for (var i = pathObjArray.length - 1; i >= 0; i--){
    if (pathObjArray[i].isContainer){
      refObjName = pathObjArray[i].getRefObj();
      break;
    }
  }
  attr["parent"] = refObjName;

  var strObjPar = maskat.composeParam(domElem, attr);
  output += attr.name + " = new rialto.widget.colorPanel(" + strObjPar + ");\n";

  return output;
}

rialto.widget.colorPanel=function(objPar){
    objPar.type = "colorPanel";
    this.base=rialto.widget.AbstractComponent;
    this.base(objPar) ;

    var oThis = this;
    this.divExt.id = this.id + "_DivGen";
    this.divExt.style.position = this.position;
    this.divExt.style.left = this.left + "px";
    this.divExt.style.top = this.top + "px";
    this.divExt.style.width = this.width;
    this.divExt.style.height = this.height;
    this.divExt.style.backgroundColor = objPar.color;

    this.divExt.innerHTML = "<div>colorPanel</div>";

    if(objPar.parent){this.placeIn(objPar.parent);};
}
rialto.widget.colorPanel.prototype=new rialto.widget.AbstractComponent;

rialto.widget.colorPanel.prototype.setValue=function(color){
    this.divExt.style.backgroundColor = color;
}

ObjWrapper.prototype.isSingleDataObj = function(){
  if (maskat.isRialtoObj(this.obj)){
    switch (this.obj.type){
      case "label":
      case "text":
      case "combo":
      case "checkbox":
      case "radioGroup":
      case "codelib":
      case "divHtml":
      case "colorPanel":
        return true;
      default:
        return false;
    }
  }
  else {
    return !maskat.isArray(this.obj);
  }
}

ObjWrapper.prototype.setSingleValue = function(val){
  if (!this.isSingleDataObj()){
    throw new MaskatError({name: "Type Error",
                           message: "複数データ型のオブジェクトに対してこの関数は実行できません。",
                           fileName: "objWrapper.js",
                           functionName: "ObjWrapper.prototype.setSingleValue"});

  }
  else {
    if (maskat.isRialtoObj(this.obj)){
      switch (this.obj.type){
        case "label":
          this.obj.setText(val);
          break;
        case "text":
          this.obj.setValue(val);
          break;
        case "combo":
          this.obj.selWithValue(val);
          break;
        case "checkbox":
          if (val == "true"){
            this.obj.setCheck(true);
          }
          else {
            this.obj.setCheck(false);
          }
          break;
        case "radioGroup":
          this.obj.setSelValue(val);
          break;
        case "divHtml":
          this.obj.setElement(val);
          break;
        case "colorPanel":
          this.obj.setValue(val);
          break;
      }
    }
    else{
      throw new Error("非rialtoオブジェクトはsetValueできない。"+this.obj.base);
    }
  }
}
