﻿/*
 * Copyright (c) 2007 NTT DATA CORPORATION
 *
 * This software is the confidential and proprietary information of
 * NTT DATA CORPORATION. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with NTT DATA
 */

package org.maskathotel;

import java.io.*;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

class HotelData {
    public String id;
    public String name;
    public String day;
    public int place;  /* 0: ginza, 1: shinjuku, 2: shibuya */
    public int room;    /* 0: single, 1: double */
    public int charge;
    public String detail;
    public HotelData(String id, String name, String day, int place,
            int room, int charge, String detail) {
        this.id = id;
        this.name = name;
        this.day = day;
        this.place = place;
        this.room = room;
        this.charge = charge;
        this.detail = detail;
    }
    public String getPlace(){
        switch(this.place){
        case 0: return "銀座";
        case 1: return "新宿";
        case 2: return "渋谷";
        }
        return null;
    }
    public String getRoom(){
        switch(this.room){
        case 0: return "シングル";
        case 1: return "ダブル";
        }
        return null;
    }
    public boolean matching(String day, boolean placeGinza, boolean placeShinjuku,
            boolean placeShibuya, int room, int charge){
        if (!this.day.equals(day)){ return false; }
        switch(this.place){
        case 0:
            if (!placeGinza){ return false; }
            break;
        case 1:
            if (!placeShinjuku){ return false; }
            break;
        case 2:
            if (!placeShibuya){ return false; }
            break;
        }
        if (this.room != room){ return false; }
        if (this.charge > charge){ return false; }
       
        return true;
    }
}

 public class MaskatHotelServlet extends javax.servlet.http.HttpServlet implements javax.servlet.Servlet {
    private ArrayList hotelDataList = new ArrayList();
     
	public MaskatHotelServlet() {
		super();

        hotelDataList.add(new HotelData("H001","Aホテル","01/01/2007",0,0,7000,"住所：東京都○○区△△□-□-□\nお薦め度★\nアメニティ充実"));
        hotelDataList.add(new HotelData("H002","Aホテル","02/01/2007",1,1,12000,"住所：東京都○○区△△□-□-□\nお薦め度★★\n眺め絶景"));
        hotelDataList.add(new HotelData("H003","Bホテル","03/01/2007",2,0,8000,"住所：東京都○○区△△□-□-□\nお薦め度★★★\n駅から近い"));
        hotelDataList.add(new HotelData("H004","Bホテル","04/01/2007",0,0,11000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★\n繁華街近く"));
        hotelDataList.add(new HotelData("H005","Cホテル","01/01/2007",1,1,9000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★★\nオーシャンビュー"));
        hotelDataList.add(new HotelData("H006","Cホテル","02/01/2007",2,1,10000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★★★\n20%OFFキャンペーン中"));
        hotelDataList.add(new HotelData("H007","Dホテル","03/01/2007",0,0,7000,"住所：東京都○○区△△□-□-□\nお薦め度★\n30%OFFキャンペーン中"));
        hotelDataList.add(new HotelData("H008","Dホテル","04/01/2007",1,0,12000,"住所：東京都○○区△△□-□-□\nお薦め度★★\nアメニティ充実"));
        hotelDataList.add(new HotelData("H009","Eホテル","01/01/2007",2,0,8000,"住所：東京都○○区△△□-□-□\nお薦め度★★★\n眺め絶景"));
        hotelDataList.add(new HotelData("H010","Eホテル","02/01/2007",0,1,11000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★\n駅から近い"));
        hotelDataList.add(new HotelData("H011","Fホテル","03/01/2007",1,1,9000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★★\n繁華街近く"));
        hotelDataList.add(new HotelData("H012","Fホテル","04/01/2007",2,1,10000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★★★\nオーシャンビュー"));
        hotelDataList.add(new HotelData("H013","Gホテル","01/01/2007",0,0,7000,"住所：東京都○○区△△□-□-□\nお薦め度★\n20%OFFキャンペーン中"));
        hotelDataList.add(new HotelData("H014","Gホテル","02/01/2007",1,0,12000,"住所：東京都○○区△△□-□-□\nお薦め度★★\n30%OFFキャンペーン中"));
        hotelDataList.add(new HotelData("H015","Hホテル","03/01/2007",2,0,8000,"住所：東京都○○区△△□-□-□\nお薦め度★★★\nアメニティ充実"));
        hotelDataList.add(new HotelData("H016","Hホテル","04/01/2007",0,0,11000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★\n眺め絶景"));
        hotelDataList.add(new HotelData("H017","Iホテル","01/01/2007",1,1,9000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★★\n駅から近い"));
        hotelDataList.add(new HotelData("H018","Iホテル","02/01/2007",2,1,10000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★★★\n繁華街近く"));
        hotelDataList.add(new HotelData("H019","Jホテル","03/01/2007",0,1,7000,"住所：東京都○○区△△□-□-□\nお薦め度★\nオーシャンビュー"));
        hotelDataList.add(new HotelData("H020","Jホテル","04/01/2007",1,1,12000,"住所：東京都○○区△△□-□-□\nお薦め度★★\n20%OFFキャンペーン中"));
        hotelDataList.add(new HotelData("H021","Kホテル","01/01/2007",2,0,8000,"住所：東京都○○区△△□-□-□\nお薦め度★★★\n30%OFFキャンペーン中"));
        hotelDataList.add(new HotelData("H022","Kホテル","02/01/2007",0,0,11000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★\nアメニティ充実"));
        hotelDataList.add(new HotelData("H023","Lホテル","03/01/2007",1,0,9000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★★\n眺め絶景"));
        hotelDataList.add(new HotelData("H024","Lホテル","04/01/2007",2,0,10000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★★★\n駅から近い"));
        hotelDataList.add(new HotelData("H025","Mホテル","01/01/2007",0,0,7000,"住所：東京都○○区△△□-□-□\nお薦め度★\n繁華街近く"));
        hotelDataList.add(new HotelData("H026","Mホテル","02/01/2007",1,1,12000,"住所：東京都○○区△△□-□-□\nお薦め度★★\nオーシャンビュー"));
        hotelDataList.add(new HotelData("H027","Nホテル","03/01/2007",2,1,8000,"住所：東京都○○区△△□-□-□\nお薦め度★★★\n20%OFFキャンペーン中"));
        hotelDataList.add(new HotelData("H028","Nホテル","04/01/2007",0,1,11000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★\n30%OFFキャンペーン中"));
        hotelDataList.add(new HotelData("H029","Oホテル","01/01/2007",1,1,9000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★★\nアメニティ充実"));
        hotelDataList.add(new HotelData("H030","Oホテル","02/01/2007",2,1,10000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★★★\n眺め絶景"));
        hotelDataList.add(new HotelData("H031","Pホテル","03/01/2007",0,0,7000,"住所：東京都○○区△△□-□-□\nお薦め度★\n駅から近い"));
        hotelDataList.add(new HotelData("H032","Pホテル","04/01/2007",1,1,12000,"住所：東京都○○区△△□-□-□\nお薦め度★★\n眺め絶景"));
        hotelDataList.add(new HotelData("H033","Qホテル","01/01/2007",2,0,8000,"住所：東京都○○区△△□-□-□\nお薦め度★★★\n繁華街近く"));
        hotelDataList.add(new HotelData("H034","Qホテル","02/01/2007",0,0,11000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★\nオーシャンビュー"));
        hotelDataList.add(new HotelData("H035","Rホテル","03/01/2007",1,1,9000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★★\n20%OFFキャンペーン中"));
        hotelDataList.add(new HotelData("H036","Rホテル","04/01/2007",2,1,10000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★★★\n30%OFFキャンペーン中"));
        hotelDataList.add(new HotelData("H037","Sホテル","01/01/2007",0,0,7000,"住所：東京都○○区△△□-□-□\nお薦め度★\nアメニティ充実"));
        hotelDataList.add(new HotelData("H038","Sホテル","02/01/2007",1,0,12000,"住所：東京都○○区△△□-□-□\nお薦め度★★\n眺め絶景"));
        hotelDataList.add(new HotelData("H039","Tホテル","03/01/2007",2,0,8000,"住所：東京都○○区△△□-□-□\nお薦め度★★★\n駅から近い"));
        hotelDataList.add(new HotelData("H040","Tホテル","04/01/2007",0,1,11000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★\n繁華街近く"));
        hotelDataList.add(new HotelData("H041","Uホテル","01/01/2007",0,1,9000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★★\nオーシャンビュー"));
        hotelDataList.add(new HotelData("H042","Uホテル","02/01/2007",1,1,10000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★★★\n20%OFFキャンペーン中"));
        hotelDataList.add(new HotelData("H043","Vホテル","03/01/2007",2,0,7000,"住所：東京都○○区△△□-□-□\nお薦め度★\n30%OFFキャンペーン中"));
        hotelDataList.add(new HotelData("H044","Vホテル","04/01/2007",0,0,12000,"住所：東京都○○区△△□-□-□\nお薦め度★★\nアメニティ充実"));
        hotelDataList.add(new HotelData("H045","Wホテル","01/01/2007",1,0,8000,"住所：東京都○○区△△□-□-□\nお薦め度★★★\n眺め絶景"));
        hotelDataList.add(new HotelData("H046","Wホテル","02/01/2007",2,0,11000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★\n駅から近い"));
        hotelDataList.add(new HotelData("H047","Xホテル","03/01/2007",0,1,9000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★★\n繁華街近く"));
        hotelDataList.add(new HotelData("H048","Xホテル","04/01/2007",1,1,10000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★★★\nオーシャンビュー"));
        hotelDataList.add(new HotelData("H049","Yホテル","01/01/2007",2,1,7000,"住所：東京都○○区△△□-□-□\nお薦め度★\n20%OFFキャンペーン中"));
        hotelDataList.add(new HotelData("H050","Yホテル","02/01/2007",0,1,12000,"住所：東京都○○区△△□-□-□\nお薦め度★★\n30%OFFキャンペーン中"));
        hotelDataList.add(new HotelData("H051","Zホテル","03/01/2007",0,0,8000,"住所：東京都○○区△△□-□-□\nお薦め度★★★\nアメニティ充実"));
        hotelDataList.add(new HotelData("H052","Zホテル","04/01/2007",1,0,11000,"住所：東京都○○区△△□-□-□\nお薦め度★★★★\n眺め絶景"));
	}   	

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		request.setCharacterEncoding("UTF-8");

		String componentID = request.getHeader("maskat_componentID");
		String eventID = request.getHeader("maskat_eventID");
		
		BufferedReader requestReader = new BufferedReader(new InputStreamReader(request.getInputStream()));
		StringBuffer stringBuffer = new StringBuffer();
		String line;
		while ((line = requestReader.readLine()) != null) {
		  stringBuffer.append(line);
		}
		String xmlString = stringBuffer.toString();
		DocumentBuilder builder = null;
		try {
			builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		}
		Document requestDocument = null;
		try {
			requestDocument = builder.parse(new InputSource(new StringReader(xmlString)));
		} catch (SAXException e) {
			e.printStackTrace();
		}
		Element rootElement = requestDocument.getDocumentElement();

		response.setContentType("text/xml;charset=UTF-8");
		PrintWriter out = response.getWriter();

		if (("searchButton".equals(componentID)) && "onclick".equals(eventID)){
			Node dayNode = rootElement.getElementsByTagName("day").item(0);
			Node placeGinzaNode = rootElement.getElementsByTagName("placeGinza").item(0);
			Node placeShinjukuNode = rootElement.getElementsByTagName("placeShinjuku").item(0);
			Node placeShibuyaNode = rootElement.getElementsByTagName("placeShibuya").item(0);
			Node roomNode = rootElement.getElementsByTagName("room").item(0);
			Node chargeMaxNode = rootElement.getElementsByTagName("chargeMax").item(0);
            
            String day = (String)dayNode.getChildNodes().item(0).getNodeValue();
            boolean placeGinza = false;
            if ("true".equals((String)placeGinzaNode.getChildNodes().item(0).getNodeValue())){
                placeGinza = true;
            }
            boolean placeShinjuku = false;
            if ("true".equals((String)placeShinjukuNode.getChildNodes().item(0).getNodeValue())){
                placeShinjuku = true;
            }
            boolean placeShibuya = false;
            if ("true".equals((String)placeShibuyaNode.getChildNodes().item(0).getNodeValue())){
                placeShibuya = true;
            }
            int room = -1;
            if ("roomSingleComboItem".equals((String)roomNode.getChildNodes().item(0).getNodeValue())){
                room = 0;
            }
            else if ("roomDoubleComboItem".equals((String)roomNode.getChildNodes().item(0).getNodeValue())){
                room = 1;
            }
            int charge = Integer.parseInt((String)(chargeMaxNode.getChildNodes().item(0).getNodeValue()));
            
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><hotelList><rows>");
            
            Iterator it = hotelDataList.iterator();
            while (it.hasNext()){
                HotelData hd = (HotelData)it.next();
                if (hd.matching(day, placeGinza, placeShinjuku, placeShibuya, room, charge)){
                    sb.append("<row><id>");
                    sb.append(hd.id);
                    sb.append("</id><name>");
                    sb.append(hd.name);
                    sb.append("</name><place>");
                    sb.append(hd.getPlace());
                    sb.append("</place><room>");
                    sb.append(hd.getRoom());
                    sb.append("</room><charge>");
                    sb.append(hd.charge);
                    sb.append("</charge></row>");
                }
            }
            sb.append("</rows></hotelList>");
    
            out.println(sb.toString());
		}
        else if (("hotelDetailGrid".equals(componentID)) && "onclick".equals(eventID)){
            Node idNode = rootElement.getElementsByTagName("id").item(0);
            String id = (String)idNode.getChildNodes().item(0).getNodeValue();
            
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><hotelDetail><detail>");

            Iterator it = hotelDataList.iterator();
            while (it.hasNext()){
                HotelData hd = (HotelData)it.next();
                if (hd.id.equals(id)){
                    sb.append(hd.detail);
                    break;
                }
            }
            sb.append("</detail></hotelDetail>");
            out.println(sb.toString());
        }
        else if (("changeColorButton".equals(componentID)) && "onclick".equals(eventID)){

            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><cp><color>#0000FF</color></cp>");
            out.println(sb.toString());
        }

	}   	  	    
}