/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.gef.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.IContainerDef;

public class OrphanChildrenCommand
extends Command {
    private List components;
    private List oriParents;
    private List oriConstraints;
    private List oriIndices;

    public OrphanChildrenCommand(List components) {
        this.components = components;
    }

    public void execute() {
        this.oriParents = new ArrayList();
        this.oriConstraints = new ArrayList();
        this.oriIndices = new ArrayList();
        int i = 0;
        while (i < this.components.size()) {
            IComponentDef comp = (IComponentDef)this.components.get(i);
            this.oriParents.add(comp.getParent());
            Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(), comp.getWidth(), comp.getHeight());
            this.oriConstraints.add(constraint);
            this.oriIndices.add(new Integer(comp.getParent().getChildIdx(comp)));
            comp.getParent().removeChild(comp);
            ++i;
        }
    }

    public boolean canExecute() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        int i = 0;
        while (i < this.components.size()) {
            IComponentDef comp = (IComponentDef)this.components.get(i);
            IContainerDef oriParent = (IContainerDef)this.oriParents.get(i);
            Rectangle cons = (Rectangle)this.oriConstraints.get(i);
            comp.setConstraint(cons.x, cons.y, cons.width, cons.height);
            int oriIndex = (Integer)this.oriIndices.get(i);
            oriParent.addChildToIdx(comp, oriIndex);
            ++i;
        }
    }
}

