package org.maskat.core.node;

/**
 * リーフノード
 * <pre>
 * ノードの末端を表すクラス
 * </pre>
 */
public class LeafNode implements Node {

	private final String xml;
	
	/**
	 * コンストラクタ
	 * @param nodeName ノード名
	 * @param value ノード値
	 */
	public LeafNode(String nodeName, String value) {
		xml = "<" + nodeName + ">" + value + "</" + nodeName + ">";
	}

	/**
	 * @see org.maskat.core.node.Node#getXML()
	 */
	public String getXML() {
		return xml;
	}
}