
maskat.syntax["googleMap"]= {
    name: {type: "string"},
    top: {type: "number"},
    left: {type: "number"},
    width: {type: "number"},
    height: {type: "number"},
    initialLongitude: {type: "number"},
    initialLatitude: {type: "number"},
    initialZoomLevel: {type: "number"},
    parent: {type: "object"},
    mapControl: {type:"enum", elem: ["large","small"]},
    typeControl: {type:"boolean"},
    doubleClickZoom: {type:"boolean"},
    continuousZoom: {type:"boolean"}
  };

maskat.transGoogleMapTag = function(pathObjArray, domElem){
  var attr = {};

  //// ̎擾
  maskat.receiveAttributes(domElem, attr);

  //// Oϊ

  // pathObjArray̗vf~ɑAisContainervpeBtrue
  // ̃IuWFNggetRefObj\bh̖߂l擾
  var refObjName=null;
  for (var i = pathObjArray.length - 1; i >= 0; i--){
    if (pathObjArray[i].isContainer){
      refObjName = pathObjArray[i].getRefObj();
      break;
    }
  }

  attr["parent"] = refObjName;

  var strObjPar = maskat.composeParam(domElem, attr);

  var output = attr.name + " = new maskat.widget.GoogleMap(" + strObjPar + ");\n";
  return output;
}

maskat.widget={};

maskat.widget.GoogleMap = function(objPar){
    //if parent is not specified then create a div DOM object as the parent
    var parentObj = objPar.parent;
    if (parentObj==null){
        parentObj = document.body;
        objPar.parent = document.body;
    }

    this.base=rialto.widget.AbstractComponent;
    this.base(objPar);
    this.parent = objPar.parent;

    var gmap2Defined = true;
    try{
        GMap2;
    }catch(e){gmap2Defined=false;}
    //check if gmap2 object is already defined(google maps API is already loaded)
    if (gmap2Defined==false){
        if (objPar.key==null)
            throw new MaskatError({name: "layoutXML Syntax Error",
                           message: "O[O}bvR|[lg\߃[hĂȂꍇkeyK{łB",
                           fileName: "googleMapEx.js",
                           functionName: "maskat.widget.GoogleMap"});
        else{
            //if not,load gmap2 object with the key
            //
            maskat.loadJSFile("http://maps.google.com/maps?file=api&amp;v=2&amp;key="+objPar.key);
            if (GMap2==null){
                throw new MaskatError({name: "O[O}bvAPI[hs",
                           message: "O[O}bvAPI[hɎs܂B",
                           fileName: "googleMapEx.js",
                           functionName: "maskat.widget.GoogleMap"});
            }
        }
    }

    this.divExt.id=this.id+"_DivGen";
    this.divExt.style.position=this.position;
    this.divExt.style.left=this.left+"px";
    this.divExt.style.top=this.top+"px";
    this.divExt.style.width=this.width+"px";
    this.divExt.style.height=this.height+"px";
    this.divExt.style.overflow='hidden';
    this.divExt.style.textOverflow="ellipsis";
    this.divExt.style.whiteSpace="nowrap";
    if(this.parent){this.placeIn(this.parent);};

    this.map = new GMap2(this.divExt);
    var longitude=0;
    var latitude=0;
    if (objPar.initialLongitude !=null && objPar.initialLatitude!=null){
    	longitude=objPar.initialLongitude;
    	latitude=objPar.initialLatitude;
    }
    var zoomLevel = 10;
    if (objPar.initialZoomLevel !=null){
    	zoomLevel=objPar.initialZoomLevel;
    }
    this.map.setCenter(new GLatLng(latitude, longitude), zoomLevel);
    if (objPar.mapControl=="large"){
        this.map.addControl(new GLargeMapControl());
    }
    if (objPar.mapControl=="small"){
        this.map.addControl(new GSmallMapControl());
    }
    if (objPar.typeControl==true){
        this.map.addControl(new GMapTypeControl());
    }
    if (objPar.doubleClickZoom==true){
    	this.map.enableDoubleClickZoom();
    }
    if (objPar.continuousZoom==true){
    	this.map.enableContinuousZoom();
    }
}

maskat.widget.GoogleMap.prototype = new rialto.widget.AbstractComponent;

maskat.widget.GoogleMap.prototype.setCenter = function(latitude,longitude){
    this.map.setCenter(new GLatLng(latitude,longitude));
}

maskat.widget.GoogleMap.prototype.setMarkerAt = function(latitude,longitude){
	var mp = new GLatLng(latitude, longitude);
	var marker = new GMarker(mp);
	this.map.addOverlay(marker);
}

maskat.widget.GoogleMap.prototype.getCenter = function(){
    return this.map.getCenter();
}

maskat.widget.GoogleMap.prototype.openInfoWindow = function(latitude,longitude,text){
    this.map.openInfoWindow(new GLatLng(latitude, longitude),document.createTextNode(text));
}

maskat.widget.GoogleMap.prototype.closeInfoWindow = function(){
    this.map.closeInfoWindow();
}

maskat.widget.GoogleMap.prototype.setDoubleClickZoom = function(doubleClickZoom){
    if (doubleClickZoom==true){
        this.map.enableDoubleClickZoom();
    }else{
        this.map.disableDoubleClickZoom();
    }
}

maskat.googleMap={};


//ȉ͓d}bsObp[g

/**
 * dTv<mapData><lat>123.456</lat><lng>12.23</lng></mapData>
 * dɎw肷WʒuɈړ
 */
maskat.googleMap.panToLatLngTeleConsumer={};
maskat.googleMap.panToLatLngTeleConsumer.consume=function(targetObj,teleNode){
    if ((targetObj==null) || !(targetObj instanceof maskat.widget.GoogleMap)){
        throw new MaskatError({name: "panToLatLngTeleConsumerG[",
                         message: "targetObjmaskat.widget.GoogleMapł͂܂",
                         fileName: "googleMapEx.js",
                         functionName: "maskat.googleMap.panToLatLngTeleConsumer.consume"});
    }
    //dteleNode͈Ȃł͂
    var lat = maskat.xpath(teleNode[0], 'lat/text()');
    var lng = maskat.xpath(teleNode[0], 'lng/text()');
    targetObj.setCenter(lat,lng);
}
ObjWrapper.registerTeleConsumer("googleMap.panToLatLng",maskat.googleMap.panToLatLngTeleConsumer);

/**
 * dTv<mapData><lat>123.456</lat><lng>12.23</lng></mapData>
 * dɎw肷WʒuɃ}[J[
 */
maskat.googleMap.markAtLatLngTeleConsumer={};
maskat.googleMap.markAtLatLngTeleConsumer.consume=function(targetObj,teleNode){
    if ((targetObj==null) || !(targetObj instanceof maskat.widget.GoogleMap)){
        throw new MaskatError({name: "markAtLatLngTeleConsumerG[",
                         message: "targetObjmaskat.widget.GoogleMapł͂܂",
                         fileName: "googleMapEx.js",
                         functionName: "maskat.googleMap.markAtLatLngTeleConsumer.consume"});
    }
    //dteleNode͈Ȃł͂
    var lat = maskat.xpath(teleNode[0], 'lat/text()');
    var lng = maskat.xpath(teleNode[0], 'lng/text()');
    targetObj.setMarkerAt(lat,lng);
}
ObjWrapper.registerTeleConsumer("googleMap.markAtLatLng",maskat.googleMap.markAtLatLngTeleConsumer);

/**
 * dTv<mapData><lat>123.456</lat><lng>12.23</lng><text>oeLXg</text></mapData>
 * dɎw肷Wʒuɐo
 */
maskat.googleMap.infoWinAtLatLngTeleConsumer={};
maskat.googleMap.infoWinAtLatLngTeleConsumer.consume=function(targetObj,teleNode){
    if ((targetObj==null) || !(targetObj instanceof maskat.widget.GoogleMap)){
        throw new MaskatError({name: "infoWinAtLatLngTeleConsumerG[",
                         message: "targetObjmaskat.widget.GoogleMapł͂܂",
                         fileName: "googleMapEx.js",
                         functionName: "maskat.googleMap.infoWinAtLatLngTeleConsumer.consume"});
    }
    //dteleNode͈Ȃł͂
    var lat = maskat.xpath(teleNode[0], 'lat/text()');
    var lng = maskat.xpath(teleNode[0], 'lng/text()');
    var text = maskat.xpath(teleNode[0], 'text/text()');
    targetObj.openInfoWindow(lat,lng,text);
}
ObjWrapper.registerTeleConsumer("googleMap.infoWinAtLatLng",maskat.googleMap.infoWinAtLatLngTeleConsumer);

/**
 * dTv<mapData><lat>123.456</lat><lng>12.23</lng><text>oeLXg</text></mapData>
 * dɎw肷WŃ}[J[āA}[J[onclickxɃeLXgo\
 */
maskat.googleMap.markExAtLatLngTeleConsumer={};
maskat.googleMap.markExAtLatLngTeleConsumer.consume=function(targetObj,teleNode){
    if ((targetObj==null) || !(targetObj instanceof maskat.widget.GoogleMap)){
        throw new MaskatError({name: "markExAtLatLngTeleConsumerG[",
                         message: "targetObjmaskat.widget.GoogleMapł͂܂",
                         fileName: "googleMapEx.js",
                         functionName: "maskat.googleMap.markExAtLatLngTeleConsumer.consume"});
    }
    //dteleNode͈Ȃł͂
    var lat = maskat.xpath(teleNode[0], 'lat/text()');
    var lng = maskat.xpath(teleNode[0], 'lng/text()');
    var text = maskat.xpath(teleNode[0], 'text/text()');
    targetObj.setMarkerAt(lat,lng);
    GEvent.addListener(targetObj.map, 'click', function(overlay, point) {
        if (overlay && overlay.openInfoWindow!=null) {
          overlay.openInfoWindow(document.createTextNode(text));
        }
    });
}
ObjWrapper.registerTeleConsumer("googleMap.markExAtLatLng",maskat.googleMap.markExAtLatLngTeleConsumer);

//d[J[
maskat.googleMap.latLngTeleMaker={};
maskat.googleMap.latLngTeleMaker.make = function(obj,validator,sourceNode){
    if ((obj==null) || !(obj instanceof maskat.widget.GoogleMap)){
        throw new MaskatError({name: "latLngTeleMakerG[",
                         message: "objmaskat.widget.GoogleMapł͂܂",
                         fileName: "googleMapEx.js",
                         functionName: "maskat.googleMap.latLngTeleMaker.make"});
    }
    var center = obj.getCenter();
    var content = "<lat>"+center.lat()+"</lat><lng>"+center.lng()+"</lng>";
    
    var nodeName = maskat.xpath(sourceNode,"@node");
    if (nodeName!=null)
      return "<" + nodeName + ">" + content + "</" + nodeName + ">";
    else
      return content;
}
ObjWrapper.registerTeleMaker("googleMap.latLng",maskat.googleMap.latLngTeleMaker);

