/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.view;

import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class MaskatPropertySheet extends PropertySheet {
	private PropertySheetPage page;

	/*
	 * (non-Javadoc) Method declared on PageBookView. Returns the default
	 * property sheet page.
	 */
	protected IPage createDefaultPage(PageBook book) {
		page = new MaskatPropertySheetPage();
		initPage(page);
		page.createControl(book);
		return page;
	}

	public void refresh() {
		if (page != null)
			page.refresh();
	}
}
