/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property.descriptor;

import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.maskat.ide.MaskatIDEUtil;
import org.maskat.ide.editors.MaskatEditor;
import org.maskat.ide.property.ParamProperty;
import org.maskat.ide.property.ResultProperty;
import org.maskat.ide.view.MaskatEditView;

/**
 * 
 */
public class SelectPropertyDescriptor extends PropertyDescriptor {

	/**
	 * @param id
	 * @param displayName
	 */
	public SelectPropertyDescriptor(Object id, String displayName) {
		super(id, displayName);
	}

	public CellEditor createPropertyEditor(Composite parent) {
		SelectCellEditor editor = new SelectCellEditor(parent);
		if (getValidator() != null) {
			editor.setValidator(getValidator());
		}
		return editor;
	}

	public static class SelectCellEditor extends CellEditor {

		/** PropertySheetEntryĂvalues */
		// private Object[] values;
		private Button button;

		private Object value = null;

		// public void setValues(Object[] values) {
		// this.values = values;
		// }

		protected SelectCellEditor(Composite parent) {
			super(parent, SWT.NONE);
		}

		protected Control createControl(Composite parent) {

			button = new Button(parent, SWT.DOWN);
			button.setText("ҏW");
			button.setFont(parent.getFont());
			button.addKeyListener(new KeyAdapter() {
				public void keyReleased(KeyEvent e) {
					if (e.character == '\u001b') { // Escape
						fireCancelEditor();
					}
				}
			});
			button.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent event) {
					MaskatEditView editView = MaskatIDEUtil.getMaskatEditView();
					if (editView != null) {
						IEditorPart ep = MaskatIDEUtil.getActiveEditor();
						if (ep instanceof MaskatEditor) {
							((MaskatEditor) ep).editMode = MaskatEditor.SOURCE_EDIT_MODE;
							try {
								startEdit((MaskatEditor) ep);
							} catch (PartInitException e) {
								ErrorDialog.openError(PlatformUI.getWorkbench()
										.getActiveWorkbenchWindow().getShell(),
										"MaskatEditr[\", // ^Cg
										"MaskatEditr[\Ɏs܂B", // G[bZ[W
										e.getStatus());

							}
						}
					}
				}
			});

			setValueValid(true);

			return button;
		}

		protected Object doGetValue() {
			return value;
		}

		protected void doSetFocus() {
			button.setFocus();
		}

		protected void doSetValue(Object value) {
			this.value = value;
		}

		private void startEdit(MaskatEditor ep) throws PartInitException {
			if (value != null) {
				if (value instanceof ParamProperty) {
					ParamProperty pp = (ParamProperty) value;
					MaskatIDEUtil.getMaskatEditView().showParam(pp, ep);
				}
				if (value instanceof ResultProperty) {
					ResultProperty rp = (ResultProperty) value;
					MaskatIDEUtil.getMaskatEditView().showResult(rp, ep);
				}
				PlatformUI.getWorkbench().getActiveWorkbenchWindow()
						.getActivePage().showView(
								"org.maskat.ide.views.MaskatEditView");
			}
		}

	}
}
