/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.figure;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;

public class ImageFigure extends Label {
	protected void paintFigure(Graphics graphics) {
		super.paintFigure(graphics);
		graphics.translate(bounds.x, bounds.y);
		graphics.drawLine(0, 0, bounds.width, bounds.height);
		graphics.drawLine(bounds.width, 0, 0, bounds.height);
		graphics.translate(-bounds.x, -bounds.y);
	}
}
