/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.maskat.ide.view.MaskatEditView;
import org.maskat.ide.view.MaskatPropertySheet;

public class MaskatIDEUtil {
	public static IEditorPart getActiveEditor() {
		IWorkbenchPage page = getActivePage();
		IEditorPart editorPart = page.getActiveEditor();
		return editorPart;
	}

	public static IWorkbenchPage getActivePage() {
		IWorkbench workbench = PlatformUI.getWorkbench();
		IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
		IWorkbenchPage page = window.getActivePage();
		return page;
	}

	public static MaskatEditView getMaskatEditView() {
		IViewReference[] refs = getActivePage().getViewReferences();
		if (refs != null) {
			for (int i = 0; i < refs.length; i++) {
				IViewReference ref = refs[i];
				if ("org.maskat.ide.views.MaskatEditView".equals(ref.getId())) {
					return (MaskatEditView) ref.getView(true);
				}
			}
		}
		return null;
	}

	public static MaskatPropertySheet getMaskPropertySheet() {
		IViewReference[] refs = getActivePage().getViewReferences();
		if (refs != null) {
			for (int i = 0; i < refs.length; i++) {
				IViewReference ref = refs[i];
				if ("org.maskat.ide.views.MaskatPropertySheet".equals(ref
						.getId())) {
					return (MaskatPropertySheet) ref.getView(true);
				}
			}
		}
		return null;
	}

	// public static MaskatEditor getMaskatEditorForLayoutDef(LayoutDef def) {
	// IEditorReference[] refs = getActivePage().getEditorReferences();
	// if (refs != null) {
	// for (int i = 0; i < refs.length; i++) {
	// IEditorPart editPart = refs[i].getEditor(false);
	// if (editPart instanceof MaskatEditor) {
	// if (((MaskatEditor) editPart).isEditorFor(def))
	// return (MaskatEditor) refs[i].getEditor(true);
	// }
	// }
	// }
	//
	// return null;
	// }

	/**
	 * maskatEditordirtytrueɃZbg
	 * 
	 */
	// public static void dirtyMaskatEditorForLayoutDef(LayoutDef def) {
	// MaskatEditor editor = getMaskatEditorForLayoutDef(def);
	// if (editor != null)
	// editor.changed();
	// }
	/**
	 * project̉path
	 * 
	 * @param project
	 * @param path
	 * @return
	 * @throws CoreException
	 */
	public static IFolder createFolder(IProject project, String path)
			throws CoreException {
		path = path.replaceAll("/", "\\");
		String[] paths = path.split("\\\\");
		IFolder folder = null;
		IPath iPath = null;
		for (int i = 0; i < paths.length; i++) {
			if (iPath == null) {
				folder = project.getFolder(paths[i]);
			} else {
				iPath = iPath.append(paths[i]);
				folder = project.getFolder(iPath);
			}
			if (!folder.exists()) {
				folder.create(true, true, null);
			}
			iPath = folder.getProjectRelativePath();
		}
		return folder;
	}
}
