/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;

import java.util.List;
import java.util.Set;

/**
 * <code>IContainerDef</code> is a special component definition that could
 * contain 0 or more components or containers.
 * 
 * @author shengshen
 * 
 */
public interface IContainerDef extends IComponentDef {

	/**
	 * Recursively get all the components' names, which are contained by this
	 * container.
	 * 
	 * @param result
	 */
	public void getAllChildComponentNames(Set result);

	/**
	 * Get all the components that are directly contained by this container.<br>
	 * 
	 * @return
	 */
	public List getComponentChildren();

	/**
	 * Find the named component that is directy contained by this container. If
	 * no component could be found, return null.
	 * 
	 * @param name
	 * @return
	 */
	public IComponentDef findChild(String name);

}