/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import org.apache.xerces.utils.HexBin;
import org.apache.xerces.validators.datatype.AbstractStringValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class HexBinaryDatatypeValidator
extends AbstractStringValidator {
    public HexBinaryDatatypeValidator() throws InvalidDatatypeFacetException {
        super(null, null, false);
    }

    public HexBinaryDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        super(datatypeValidator, hashtable, bl);
    }

    protected void assignAdditionalFacets(String string, Hashtable hashtable) throws InvalidDatatypeFacetException {
        throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_STRING_FACET, 0, new Object[]{string}));
    }

    protected void checkValueSpace(String string) throws InvalidDatatypeValueException {
        if (this.getLength(string) <= 0) {
            throw new InvalidDatatypeValueException("Value '" + string + "' is not encoded in Hex");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        HexBinaryDatatypeValidator hexBinaryDatatypeValidator = null;
        try {
            hexBinaryDatatypeValidator = new HexBinaryDatatypeValidator();
            hexBinaryDatatypeValidator.fLocale = this.fLocale;
            hexBinaryDatatypeValidator.fBaseValidator = this.fBaseValidator;
            hexBinaryDatatypeValidator.fLength = this.fLength;
            hexBinaryDatatypeValidator.fMaxLength = this.fMaxLength;
            hexBinaryDatatypeValidator.fMinLength = this.fMinLength;
            hexBinaryDatatypeValidator.fPattern = this.fPattern;
            hexBinaryDatatypeValidator.fRegex = this.fRegex;
            hexBinaryDatatypeValidator.fEnumeration = this.fEnumeration;
            hexBinaryDatatypeValidator.fFacetsDefined = this.fFacetsDefined;
        }
        catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
            invalidDatatypeFacetException.printStackTrace();
        }
        return hexBinaryDatatypeValidator;
    }

    protected int getLength(String string) {
        return HexBin.getDecodedDataLength(string.getBytes());
    }
}

