/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.common.util;

/**
 * Condition check utility class.
 *
 */
public final class ConditionUtil {

    private ConditionUtil() {
    }

    /**
     * Check if passed parameter is not null.
     *
     * @param t
     *            ckeck object
     * @throws NullPointerException
     *             if object is null.
     */
    public static <T> void verifyNotNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
    }

    /**
     * Check if passed parameter is not null. If it's null, the
     * {@link NullPointerException} is thrown with a message passed as the
     * second parameter.
     *
     * @param t
     *            checked object
     * @param messasge
     *            message
     * @throws NullPointerException
     *             if object is null.
     */
    public static <T> void verifyNotNull(T t, String messasge) {
        if (t == null) {
            throw new NullPointerException(messasge);
        }
    }

    /**
     * Check if passed parameter is null.
     *
     * @param t
     *            checked object
     * @return true if checked object is null, otherwise false.
     */
    public static <T> boolean isNull(T t) {
        if (t == null) {
            return true;
        }
        return false;
    }

    /**
     * Check if passed parameter is not null.
     *
     * @param t
     *            checked object
     * @return true if checked object is not null, otherwise false.
     */
    public static <T> boolean isNotNull(T t) {
        if (t != null) {
            return true;
        }
        return false;
    }

    /**
     * Checks if two arguments are equivalent.
     *
     * @param arg1
     *            checked argument
     * @param arg2
     *            checked argument
     * @return true if two arguments are equivalent, otherwise return false.
     */
    public static <T> boolean equals(T arg1, T arg2) {
        if (arg1 == arg2) {
            return true;
        } else if (arg1 != null && arg1.equals(arg2)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Checks state passed as the first parameter. If it's false, then throws
     * Exception passed as the second parameter. The exception of the second
     * parameter must extend {@link RuntimeException}.
     *
     * @param state
     *            state
     * @param e
     *            the instance of exception
     * @throws Exception which extends {@link RuntimeException}
     */
    public static void verifyState(boolean state, RuntimeException e) {
        if (!state) {
            throw e;
        }
    }
}
