/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.common.type;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

/**
 * Parameterized class type wrapper.
 *
 */
public class WrappedParameterizedType implements ParameterizedType,
        RealType, Serializable {

	/**
     *
     */
    private static final long serialVersionUID = 8376924788595188000L;
    private ParameterizedType type;

    public WrappedParameterizedType() {
    }

    public WrappedParameterizedType(ParameterizedType type) {
        this.type = type;
    }

    public Type[] getActualTypeArguments() {
        return this.type.getActualTypeArguments();
    }

    public Type getOwnerType() {
        return this.type.getOwnerType();
    }

    public Type getRawType() {
        return this.type.getRawType();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((type == null) ? 0 : type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        WrappedParameterizedType other = (WrappedParameterizedType) obj;
        if (type == null) {
            if (other.type != null)
                return false;
        } else if (type.getRawType().equals(other.type.getRawType())
                && Arrays.equals(GenericClassType.getGenericClassTypes(type.getActualTypeArguments()),
                        GenericClassType.getGenericClassTypes(other.type.getActualTypeArguments()))) {
                return true;
        }

        return false;
    }

    public ParameterizedType getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = (ParameterizedType) type;
    }

    public static Class<?> getClassFromType(Type type) {
        return (Class<?>)((ParameterizedType) type).getRawType();
    }

    @Override
    public String toString() {
        return "WrappedParameterizedType [type=" + type + "]";
    }


}
