/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * date utility
 *
 */
public final class DateUtil {

    private DateUtil() {
    }

    /**
     * Convert the string of date to {@link Date} type using the pattern
     * format.
     *
     * @param date
     *            converted date
     * @param pattern
     *            pattern format
     * @return converted date.
     */
    public static Date s2dConvert(String date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern(pattern);

        try {
            return sdf.parse(date);
        } catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /**
     * Convert the {@link java.util.Date} of date to the string of date type
     * using the pattern format.
     *
     * @param date
     *            converted date
     * @param pattern
     *            pattern format
     * @return converted date.
     */
    public static String d2sConvert(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern(pattern);

        return sdf.format(date);
    }
}
