/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.core;

import org.maru.common.reflection.Clazz;

public final class ClassChecker {

    private ClassChecker(){}

    public static <T> void checkClassType(Class<T> type) {
        if(Clazz.isAbstractClass(type)) {
            throw new IllegalArgumentException(
                    "The " + type.getName() + " is an abstract class.");
        }
        if (Clazz.isInterface(type)) {
            throw new IllegalArgumentException(
                    "The " + type.getName() + " is an interface.");
        }
        if (Clazz.isArray(type)) {
            throw new IllegalArgumentException(
                    "The " + type.getName() + " is an array type.");
        }
        if (Clazz.isAnnotationClass(type)) {
            throw new IllegalArgumentException(
                "The " + type.getName() + " is an annotaton type.");
        }

    }

    public static <T> void checkInstanceType(T instance) {
        if (Clazz.isClassType(instance)) {
            throw new IllegalArgumentException(
                    "The " + instance + " is class type.");
        }
        if (Clazz.isAnnotation(instance)) {
            throw new IllegalArgumentException(
                " The " + instance + " is an annotation.");
        }
    }

}
