/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.converter;

import org.maru.common.annotation.Value;

public final class StringToNumberConverter {

    @ConverterIdentifier(ToByte.class)
    public Byte convertStringToByte(@Value String value) {
        return Byte.valueOf(value);
    }

    @ConverterIdentifier(ToShort.class)
    public Short convertStringToShort(@Value String value) {
        return Short.valueOf(value);
    }

    @ConverterIdentifier(ToInteger.class)
    public Integer convertStringToInteger(@Value String value) {
        return Integer.valueOf(value);
    }

    @ConverterIdentifier(ToLong.class)
    public Long convertStringToLong(@Value String value) {
        return Long.valueOf(value);
    }

    @ConverterIdentifier(ToFloat.class)
    public Float convertStringToFloat(@Value String value) {
        return Float.valueOf(value);
    }

    @ConverterIdentifier(ToDouble.class)
    public Double convertStringToDouble(@Value String value) {
        return Double.valueOf(value);
    }
}
