/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.converter;

import org.maru.common.annotation.Value;

public class NumberToStringConverter {

    @ConverterIdentifier(ByteToString.class)
    public String convertByteToString(@Value byte value) {
        return Byte.toString(value);
    }

    @ConverterIdentifier(ShortToString.class)
    public String convertShortToString(@Value short value) {
        return Short.toString(value);
    }

    @ConverterIdentifier(IntegerToString.class)
    public String convertIntegerToString(@Value int value) {
        return Integer.toString(value);
    }

    @ConverterIdentifier(LongToString.class)
    public String convertLongToString(@Value long value) {
        return Long.toString(value);
    }

    @ConverterIdentifier(FloatToString.class)
    public String convertFloatToString(@Value float value) {
        return Float.toString(value);
    }

    @ConverterIdentifier(DoubleToString.class)
    public String convertDoubleToString(@Value double value) {
        return Double.toString(value);
    }
}
