/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;


public final class OverridableBindingConfig implements BindingConfiguration {

    private String boundName = null;
    private Class<?> inputClass = null;
    private String bindName = null;
    private boolean converterOff = false;

    public OverridableBindingConfig() {}

    public OverridableBindingConfig(String boundName, Class<?> inputClass) {
        this.boundName = boundName;
        this.inputClass = inputClass;
    }

    public OverridableBindingConfig(String boundName, Class<?> inputClass,
            String bindName) {
        this.boundName = boundName;
        this.inputClass = inputClass;
        this.bindName = bindName;
    }

    public OverridableBindingConfig(String boundName, Class<?> inputClass,
            boolean converterOff) {
        this.boundName = boundName;
        this.inputClass = inputClass;
        this.converterOff = converterOff;
    }

    public OverridableBindingConfig(String boundName, Class<?> inputClass,
            String bindName, boolean converterOff) {
        this.boundName = boundName;
        this.inputClass = inputClass;
        this.bindName = bindName;
        this.converterOff = converterOff;
    }

    public String getBoundName() {
        return this.boundName;
    }

    public void setBoundName(String boundName) {
        this.boundName = boundName;
    }

    public Class<?> getInputClass() {
        return this.inputClass;
    }

    public void setInputClass(Class<?> inputClass) {
        this.inputClass = inputClass;
    }

    public String getBindName() {
        return this.bindName;
    }

    public void setBindName(String bindName) {
        this.bindName = bindName;
    }

    public boolean isConverterOff() {
        return this.converterOff;
    }

    public void setConverterOff(boolean converterOff) {
        this.converterOff = converterOff;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((bindName == null) ? 0 : bindName.hashCode());
        result = prime * result + ((boundName == null) ? 0 : boundName.hashCode());
        result = prime * result + (converterOff ? 1231 : 1237);
        result = prime * result + ((inputClass == null) ? 0 : inputClass.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OverridableBindingConfig other = (OverridableBindingConfig) obj;
        if (bindName == null) {
            if (other.bindName != null)
                return false;
        } else if (!bindName.equals(other.bindName))
            return false;
        if (boundName == null) {
            if (other.boundName != null)
                return false;
        } else if (!boundName.equals(other.boundName))
            return false;
        if (converterOff != other.converterOff)
            return false;
        if (inputClass == null) {
            if (other.inputClass != null)
                return false;
        } else if (!inputClass.equals(other.inputClass))
            return false;
        return true;
    }

}
