/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;

/**
 * The member's binder interface.
 */
public interface MemberBinder {

    /**
     * bind to target object's member.
     *
     * @param target
     */
    <T, K> void bind(T target, K input);

    /**
     * Returns {@link BindingContextImpl}
     * @return binding context.
     */
    BindingContext getBindingContext();
}
