/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;

import org.maru.dog.core.MarkedPoint;

final class MapBindingContextImpl implements BindingContext {
    private final TargetMarkedPoint<?> targetMarkedPoint;

    private final Object inputValue;

    public MapBindingContextImpl(TargetMarkedPoint<?> targetMarkedPoint, Object inputValue) {
        this.targetMarkedPoint = targetMarkedPoint;
        this.inputValue = inputValue;
    }

    public MarkedPoint<?> getMarkedPoint() {
        return targetMarkedPoint;
    }

    public Object getValue() {
        return inputValue;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((inputValue == null) ? 0 : inputValue.hashCode());
        result = prime * result + ((targetMarkedPoint == null) ? 0 : targetMarkedPoint.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        MapBindingContextImpl other = (MapBindingContextImpl) obj;
        if (inputValue == null) {
            if (other.inputValue != null)
                return false;
        } else if (!inputValue.equals(other.inputValue))
            return false;
        if (targetMarkedPoint == null) {
            if (other.targetMarkedPoint != null)
                return false;
        } else if (!targetMarkedPoint.equals(other.targetMarkedPoint))
            return false;
        return true;
    }

    @Override
    public String toString() {
        return "MapBindingContextImpl [targetMarkedPoint=" + targetMarkedPoint
                + ", inputValue=" + inputValue + "]";
    }

}
