/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;

import java.util.Map;

import org.maru.common.Key;
import org.maru.dog.core.Definition;
import org.maru.dog.core.MarkedPoint;

interface BindingDefinition<T> extends Definition<T> {

    public MarkedPoint<T> putMarkedPoint(Key<?> key, MarkedPoint<T> markedPoint);

    public MarkedPoint<T> getMarkedPoint(Key<?> key);

    public void putAllMarkedPoint(Map<Key<?>, MarkedPoint<T>> markedPoints);

    public boolean containsMarkedPoint(Key<?> key);

    public Map<Key<?>, MarkedPoint<T>> getMarkedPoints();

}
