/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;

import org.maru.dog.core.MarkedPoint;

final class BindingContextImpl implements BindingContext{

    private final TargetMarkedPoint<?> targetMarkedPoint;
    private final InputMarkedPoint<?> inputMarkedPoint;
    private final BindingConfiguration configuration;

    BindingContextImpl(TargetMarkedPoint<?> targetMarkedPoint, InputMarkedPoint<?> inputMarkedPoint, BindingConfiguration configuration) {
        this.targetMarkedPoint = targetMarkedPoint;
        this.inputMarkedPoint = inputMarkedPoint;
        this.configuration = configuration;
    }

    public MarkedPoint<?> getMarkedPoint() {
        return targetMarkedPoint;
    }

    public InputMarkedPoint<?> getInputMarkedPoint() {
        return inputMarkedPoint;
    }

    public BindingConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String toString() {
        return "BindingContextImpl [targetMarkedPoint=" + targetMarkedPoint
                + ", inputMarkedPoint=" + inputMarkedPoint
                + ", BindingConfiguration=" + configuration + "]";
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((configuration == null) ? 0 : configuration.hashCode());
        result = prime * result + ((inputMarkedPoint == null) ? 0 : inputMarkedPoint.hashCode());
        result = prime * result + ((targetMarkedPoint == null) ? 0 : targetMarkedPoint.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        BindingContextImpl other = (BindingContextImpl) obj;
        if (configuration == null) {
            if (other.configuration != null)
                return false;
        } else if (!configuration.equals(other.configuration))
            return false;
        if (inputMarkedPoint == null) {
            if (other.inputMarkedPoint != null)
                return false;
        } else if (!inputMarkedPoint.equals(other.inputMarkedPoint))
            return false;
        if (targetMarkedPoint == null) {
            if (other.targetMarkedPoint != null)
                return false;
        } else if (!targetMarkedPoint.equals(other.targetMarkedPoint))
            return false;
        return true;
    }


}
